/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import io.appform.dropwizard.actors.actor.MessageHandlingFunction;
import io.appform.dropwizard.actors.actor.MessageMetadata;
import io.appform.dropwizard.actors.exceptionhandler.handlers.ExceptionHandler;
import io.appform.dropwizard.actors.retry.RetryStrategy;
import java.io.IOException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler<Message>
extends DefaultConsumer {
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private final ObjectMapper mapper;
    private final Class<? extends Message> clazz;
    private final Function<Throwable, Boolean> errorCheckFunction;
    private final RetryStrategy retryStrategy;
    private final ExceptionHandler exceptionHandler;
    private final MessageHandlingFunction<Message, Boolean> messageHandlingFunction;
    private String tag;

    public Handler(Channel channel, ObjectMapper mapper, Class<? extends Message> clazz, int prefetchCount, Function<Throwable, Boolean> errorCheckFunction, RetryStrategy retryStrategy, ExceptionHandler exceptionHandler, MessageHandlingFunction<Message, Boolean> messageHandlingFunction) throws Exception {
        super(channel);
        this.mapper = mapper;
        this.clazz = clazz;
        this.getChannel().basicQos(prefetchCount);
        this.errorCheckFunction = errorCheckFunction;
        this.retryStrategy = retryStrategy;
        this.exceptionHandler = exceptionHandler;
        this.messageHandlingFunction = messageHandlingFunction;
    }

    private boolean handle(Message message, MessageMetadata messageMetadata) throws Exception {
        return this.messageHandlingFunction.apply(message, messageMetadata);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        try {
            Object message = this.mapper.readValue(body, this.clazz);
            boolean success = this.retryStrategy.execute(() -> this.handle(message, this.messageProperties(envelope)));
            if (success) {
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            } else {
                this.getChannel().basicReject(envelope.getDeliveryTag(), false);
            }
        }
        catch (Throwable t) {
            log.error("Error processing message...", t);
            if (this.errorCheckFunction.apply(t).booleanValue()) {
                log.warn("Acked message due to exception: ", t);
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            }
            if (this.exceptionHandler.handle()) {
                log.warn("Acked message due to exception handling strategy: ", t);
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            }
            this.getChannel().basicReject(envelope.getDeliveryTag(), false);
        }
    }

    private MessageMetadata messageProperties(Envelope envelope) {
        return new MessageMetadata(envelope.isRedeliver());
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

