/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors;

import com.google.common.base.Preconditions;
import io.appform.dropwizard.actors.ConnectionRegistry;
import io.appform.dropwizard.actors.ExecutorServiceProvider;
import io.appform.dropwizard.actors.TtlConfig;
import io.appform.dropwizard.actors.config.RMQConfig;
import io.appform.dropwizard.actors.connectivity.RMQConnection;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitmqActorBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqActorBundle.class);
    private ConnectionRegistry connectionRegistry;
    private RMQConfig rmqConfig;

    protected RabbitmqActorBundle() {
    }

    public void run(T t, Environment environment) {
        this.rmqConfig = this.getConfig(t);
        ExecutorServiceProvider executorServiceProvider = this.getExecutorServiceProvider(t);
        TtlConfig ttlConfig = this.ttlConfig();
        Preconditions.checkNotNull((Object)executorServiceProvider, (Object)"Null executor service provider provided");
        this.connectionRegistry = new ConnectionRegistry(environment, executorServiceProvider, this.rmqConfig, ttlConfig == null ? TtlConfig.builder().build() : ttlConfig);
        environment.lifecycle().manage((Managed)this.connectionRegistry);
    }

    protected abstract TtlConfig ttlConfig();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public RMQConnection getConnection() {
        return this.connectionRegistry.createOrGet("default");
    }

    protected abstract RMQConfig getConfig(T var1);

    protected ExecutorServiceProvider getExecutorServiceProvider(T t) {
        return (name, coreSize) -> Executors.newFixedThreadPool(coreSize);
    }

    public ConnectionRegistry getConnectionRegistry() {
        return this.connectionRegistry;
    }
}

