/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.retry.impl;

import com.github.rholder.retry.BlockStrategies;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import io.appform.dropwizard.actors.retry.RetryStrategy;
import io.appform.dropwizard.actors.retry.config.CountLimitedExponentialWaitRetryConfig;
import io.appform.dropwizard.actors.utils.CommonUtils;
import java.util.concurrent.TimeUnit;

public class CountLimitedExponentialWaitRetryStrategy
extends RetryStrategy {
    public CountLimitedExponentialWaitRetryStrategy(CountLimitedExponentialWaitRetryConfig config) {
        super((Retryer<Boolean>)RetryerBuilder.newBuilder().retryIfException(exception -> CommonUtils.isRetriable(config.getRetriableExceptions(), exception)).withStopStrategy(StopStrategies.stopAfterAttempt((int)config.getMaxAttempts())).withBlockStrategy(BlockStrategies.threadSleepStrategy()).withWaitStrategy(WaitStrategies.exponentialWait((long)config.getMultipier(), (long)config.getMaxTimeBetweenRetries().toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS)).build());
    }
}

