/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.retry.config;

import io.appform.dropwizard.actors.retry.RetryType;
import io.appform.dropwizard.actors.retry.config.RetryConfig;
import io.dropwizard.util.Duration;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class TimeLimitedExponentialWaitRetryConfig
extends RetryConfig {
    @NotNull
    @Valid
    private Duration maxTime = Duration.seconds((long)30L);
    @NotNull
    @Valid
    private Duration maxTimeBetweenRetries = Duration.milliseconds((long)500L);
    @Min(value=1L)
    @Max(value=0x7FFFFFFFFFFFFFFFL)
    private long multipier = 1L;

    public TimeLimitedExponentialWaitRetryConfig() {
        super(RetryType.TIME_LIMITED_EXPONENTIAL_BACKOFF);
    }

    public TimeLimitedExponentialWaitRetryConfig(Duration maxTime, Duration maxTimeBetweenRetries, long multipier, Set<String> retriableExceptions) {
        super(RetryType.TIME_LIMITED_EXPONENTIAL_BACKOFF, retriableExceptions);
        this.maxTime = maxTime;
        this.maxTimeBetweenRetries = maxTimeBetweenRetries;
        this.multipier = multipier;
    }

    public static TimeLimitedExponentialWaitRetryConfigBuilder builder() {
        return new TimeLimitedExponentialWaitRetryConfigBuilder();
    }

    public Duration getMaxTime() {
        return this.maxTime;
    }

    public Duration getMaxTimeBetweenRetries() {
        return this.maxTimeBetweenRetries;
    }

    public long getMultipier() {
        return this.multipier;
    }

    public void setMaxTime(Duration maxTime) {
        this.maxTime = maxTime;
    }

    public void setMaxTimeBetweenRetries(Duration maxTimeBetweenRetries) {
        this.maxTimeBetweenRetries = maxTimeBetweenRetries;
    }

    public void setMultipier(long multipier) {
        this.multipier = multipier;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeLimitedExponentialWaitRetryConfig)) {
            return false;
        }
        TimeLimitedExponentialWaitRetryConfig other = (TimeLimitedExponentialWaitRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$maxTime = this.getMaxTime();
        Duration other$maxTime = other.getMaxTime();
        if (this$maxTime == null ? other$maxTime != null : !this$maxTime.equals(other$maxTime)) {
            return false;
        }
        Duration this$maxTimeBetweenRetries = this.getMaxTimeBetweenRetries();
        Duration other$maxTimeBetweenRetries = other.getMaxTimeBetweenRetries();
        if (this$maxTimeBetweenRetries == null ? other$maxTimeBetweenRetries != null : !this$maxTimeBetweenRetries.equals(other$maxTimeBetweenRetries)) {
            return false;
        }
        return this.getMultipier() == other.getMultipier();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeLimitedExponentialWaitRetryConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Duration $maxTime = this.getMaxTime();
        result = result * 59 + ($maxTime == null ? 43 : $maxTime.hashCode());
        Duration $maxTimeBetweenRetries = this.getMaxTimeBetweenRetries();
        result = result * 59 + ($maxTimeBetweenRetries == null ? 43 : $maxTimeBetweenRetries.hashCode());
        long $multipier = this.getMultipier();
        result = result * 59 + (int)($multipier >>> 32 ^ $multipier);
        return result;
    }

    @Override
    public String toString() {
        return "TimeLimitedExponentialWaitRetryConfig(super=" + super.toString() + ", maxTime=" + this.getMaxTime() + ", maxTimeBetweenRetries=" + this.getMaxTimeBetweenRetries() + ", multipier=" + this.getMultipier() + ")";
    }

    public static class TimeLimitedExponentialWaitRetryConfigBuilder {
        private Duration maxTime;
        private Duration maxTimeBetweenRetries;
        private long multipier;
        private Set<String> retriableExceptions;

        TimeLimitedExponentialWaitRetryConfigBuilder() {
        }

        public TimeLimitedExponentialWaitRetryConfigBuilder maxTime(Duration maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        public TimeLimitedExponentialWaitRetryConfigBuilder maxTimeBetweenRetries(Duration maxTimeBetweenRetries) {
            this.maxTimeBetweenRetries = maxTimeBetweenRetries;
            return this;
        }

        public TimeLimitedExponentialWaitRetryConfigBuilder multipier(long multipier) {
            this.multipier = multipier;
            return this;
        }

        public TimeLimitedExponentialWaitRetryConfigBuilder retriableExceptions(Set<String> retriableExceptions) {
            this.retriableExceptions = retriableExceptions;
            return this;
        }

        public TimeLimitedExponentialWaitRetryConfig build() {
            return new TimeLimitedExponentialWaitRetryConfig(this.maxTime, this.maxTimeBetweenRetries, this.multipier, this.retriableExceptions);
        }

        public String toString() {
            return "TimeLimitedExponentialWaitRetryConfig.TimeLimitedExponentialWaitRetryConfigBuilder(maxTime=" + this.maxTime + ", maxTimeBetweenRetries=" + this.maxTimeBetweenRetries + ", multipier=" + this.multipier + ", retriableExceptions=" + this.retriableExceptions + ")";
        }
    }
}

