/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.connectivity;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ConnectionConfig {
    @NotNull
    @NotEmpty
    private String name;
    @Min(value=1L)
    @Max(value=300L)
    private int threadPoolSize;

    public static ConnectionConfigBuilder builder() {
        return new ConnectionConfigBuilder();
    }

    public String getName() {
        return this.name;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionConfig)) {
            return false;
        }
        ConnectionConfig other = (ConnectionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return this.getThreadPoolSize() == other.getThreadPoolSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getThreadPoolSize();
        return result;
    }

    public String toString() {
        return "ConnectionConfig(name=" + this.getName() + ", threadPoolSize=" + this.getThreadPoolSize() + ")";
    }

    public ConnectionConfig() {
    }

    public ConnectionConfig(String name, int threadPoolSize) {
        this.name = name;
        this.threadPoolSize = threadPoolSize;
    }

    public static class ConnectionConfigBuilder {
        private String name;
        private int threadPoolSize;

        ConnectionConfigBuilder() {
        }

        public ConnectionConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConnectionConfigBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public ConnectionConfig build() {
            return new ConnectionConfig(this.name, this.threadPoolSize);
        }

        public String toString() {
            return "ConnectionConfig.ConnectionConfigBuilder(name=" + this.name + ", threadPoolSize=" + this.threadPoolSize + ")";
        }
    }
}

