/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.actor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import io.appform.dropwizard.actors.ConnectionRegistry;
import io.appform.dropwizard.actors.actor.ActorConfig;
import io.appform.dropwizard.actors.actor.ConsumerConfig;
import io.appform.dropwizard.actors.actor.MessageHandlingFunction;
import io.appform.dropwizard.actors.actor.ProducerConfig;
import io.appform.dropwizard.actors.base.UnmanagedConsumer;
import io.appform.dropwizard.actors.base.UnmanagedPublisher;
import io.appform.dropwizard.actors.connectivity.RMQConnection;
import io.appform.dropwizard.actors.connectivity.strategy.ConnectionIsolationStrategy;
import io.appform.dropwizard.actors.connectivity.strategy.ConnectionIsolationStrategyVisitor;
import io.appform.dropwizard.actors.connectivity.strategy.DefaultConnectionStrategy;
import io.appform.dropwizard.actors.connectivity.strategy.SharedConnectionStrategy;
import io.appform.dropwizard.actors.exceptionhandler.ExceptionHandlingFactory;
import io.appform.dropwizard.actors.retry.RetryStrategyFactory;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmanagedBaseActor<Message> {
    private static final Logger log = LoggerFactory.getLogger(UnmanagedBaseActor.class);
    private final UnmanagedPublisher<Message> publishActor;
    private final UnmanagedConsumer<Message> consumeActor;

    public UnmanagedBaseActor(UnmanagedPublisher<Message> publishActor, UnmanagedConsumer<Message> consumeActor) {
        this.publishActor = publishActor;
        this.consumeActor = consumeActor;
    }

    public UnmanagedBaseActor(String name, ActorConfig config, RMQConnection connection, ObjectMapper mapper, RetryStrategyFactory retryStrategyFactory, ExceptionHandlingFactory exceptionHandlingFactory, Class<? extends Message> clazz, MessageHandlingFunction<Message, Boolean> handlerFunction, Function<Throwable, Boolean> errorCheckFunction) {
        this(new UnmanagedPublisher(name, config, connection, mapper), new UnmanagedConsumer<Message>(name, config, connection, mapper, retryStrategyFactory, exceptionHandlingFactory, clazz, handlerFunction, errorCheckFunction));
    }

    public UnmanagedBaseActor(String name, ActorConfig config, ConnectionRegistry connectionRegistry, ObjectMapper mapper, RetryStrategyFactory retryStrategyFactory, ExceptionHandlingFactory exceptionHandlingFactory, Class<? extends Message> clazz, MessageHandlingFunction<Message, Boolean> handlerFunction, Function<Throwable, Boolean> errorCheckFunction) {
        RMQConnection consumerConnection = connectionRegistry.createOrGet(this.consumerConnectionName(config.getConsumer()));
        RMQConnection producerConnection = connectionRegistry.createOrGet(this.producerConnectionName(config.getProducer()));
        this.publishActor = new UnmanagedPublisher(name, config, producerConnection, mapper);
        this.consumeActor = new UnmanagedConsumer<Message>(name, config, consumerConnection, mapper, retryStrategyFactory, exceptionHandlingFactory, clazz, handlerFunction, errorCheckFunction);
    }

    public void start() throws Exception {
        if (Objects.nonNull(this.publishActor)) {
            this.publishActor.start();
        }
        if (Objects.nonNull(this.consumeActor)) {
            this.consumeActor.start();
        }
    }

    public void stop() throws Exception {
        if (Objects.nonNull(this.publishActor)) {
            this.publishActor.stop();
        }
        if (Objects.nonNull(this.consumeActor)) {
            this.consumeActor.stop();
        }
    }

    public final void publishWithDelay(Message message, long delayMilliseconds) throws Exception {
        this.publishActor().publishWithDelay(message, delayMilliseconds);
    }

    public final void publish(Message message) throws Exception {
        this.publishActor().publish(message);
    }

    public final void publish(Message message, AMQP.BasicProperties properties) throws Exception {
        this.publishActor().publish(message, properties);
    }

    public final long pendingMessagesCount() {
        return this.publishActor().pendingMessagesCount();
    }

    private UnmanagedPublisher<Message> publishActor() {
        if (Objects.isNull(this.publishActor)) {
            throw new NotImplementedException("PublishActor is not initialized");
        }
        return this.publishActor;
    }

    private String producerConnectionName(ProducerConfig producerConfig) {
        if (producerConfig == null) {
            return "default";
        }
        return this.deriveConnectionName(producerConfig.getConnectionIsolationStrategy());
    }

    private String consumerConnectionName(ConsumerConfig consumerConfig) {
        if (consumerConfig == null) {
            return "default";
        }
        return this.deriveConnectionName(consumerConfig.getConnectionIsolationStrategy());
    }

    private String deriveConnectionName(ConnectionIsolationStrategy isolationStrategy) {
        if (isolationStrategy == null) {
            return "default";
        }
        return isolationStrategy.accept(new ConnectionIsolationStrategyVisitor<String>(){

            @Override
            public String visit(SharedConnectionStrategy strategy) {
                return strategy.getName();
            }

            @Override
            public String visit(DefaultConnectionStrategy strategy) {
                return "default";
            }
        });
    }

    public UnmanagedPublisher<Message> getPublishActor() {
        return this.publishActor;
    }

    public UnmanagedConsumer<Message> getConsumeActor() {
        return this.consumeActor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnmanagedBaseActor)) {
            return false;
        }
        UnmanagedBaseActor other = (UnmanagedBaseActor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnmanagedPublisher<Message> this$publishActor = this.getPublishActor();
        UnmanagedPublisher<Message> other$publishActor = other.getPublishActor();
        if (this$publishActor == null ? other$publishActor != null : !this$publishActor.equals(other$publishActor)) {
            return false;
        }
        UnmanagedConsumer<Message> this$consumeActor = this.getConsumeActor();
        UnmanagedConsumer<Message> other$consumeActor = other.getConsumeActor();
        return !(this$consumeActor == null ? other$consumeActor != null : !this$consumeActor.equals(other$consumeActor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnmanagedBaseActor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnmanagedPublisher<Message> $publishActor = this.getPublishActor();
        result = result * 59 + ($publishActor == null ? 43 : $publishActor.hashCode());
        UnmanagedConsumer<Message> $consumeActor = this.getConsumeActor();
        result = result * 59 + ($consumeActor == null ? 43 : $consumeActor.hashCode());
        return result;
    }

    public String toString() {
        return "UnmanagedBaseActor(publishActor=" + this.getPublishActor() + ", consumeActor=" + this.getConsumeActor() + ")";
    }
}

