/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.actor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import io.appform.dropwizard.actors.ConnectionRegistry;
import io.appform.dropwizard.actors.actor.ActorConfig;
import io.appform.dropwizard.actors.actor.UnmanagedBaseActor;
import io.appform.dropwizard.actors.base.UnmanagedConsumer;
import io.appform.dropwizard.actors.base.UnmanagedPublisher;
import io.appform.dropwizard.actors.connectivity.RMQConnection;
import io.appform.dropwizard.actors.exceptionhandler.ExceptionHandlingFactory;
import io.appform.dropwizard.actors.retry.RetryStrategyFactory;
import io.dropwizard.lifecycle.Managed;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseActor<Message>
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(BaseActor.class);
    private final UnmanagedBaseActor<Message> actorImpl;
    private final Set<Class<?>> droppedExceptionTypes;

    protected BaseActor(UnmanagedPublisher<Message> publishActor, Set<Class<?>> droppedExceptionTypes) {
        this(publishActor, null, droppedExceptionTypes);
    }

    protected BaseActor(UnmanagedConsumer<Message> consumeActor, Set<Class<?>> droppedExceptionTypes) {
        this(null, consumeActor, droppedExceptionTypes);
    }

    protected BaseActor(UnmanagedPublisher<Message> produceActor, UnmanagedConsumer<Message> consumeActor, Set<Class<?>> droppedExceptionTypes) {
        this.actorImpl = new UnmanagedBaseActor<Message>(produceActor, consumeActor);
        this.droppedExceptionTypes = droppedExceptionTypes;
    }

    @Deprecated
    protected BaseActor(String name, ActorConfig config, RMQConnection connection, ObjectMapper mapper, RetryStrategyFactory retryStrategyFactory, ExceptionHandlingFactory exceptionHandlingFactory, Class<? extends Message> clazz, Set<Class<?>> droppedExceptionTypes) {
        this.droppedExceptionTypes = null == droppedExceptionTypes ? Collections.emptySet() : droppedExceptionTypes;
        this.actorImpl = new UnmanagedBaseActor<Object>(name, config, connection, mapper, retryStrategyFactory, exceptionHandlingFactory, clazz, this::handle, this::isExceptionIgnorable);
    }

    protected BaseActor(String name, ActorConfig config, ConnectionRegistry connectionRegistry, ObjectMapper mapper, RetryStrategyFactory retryStrategyFactory, ExceptionHandlingFactory exceptionHandlingFactory, Class<? extends Message> clazz, Set<Class<?>> droppedExceptionTypes) {
        this.droppedExceptionTypes = null == droppedExceptionTypes ? Collections.emptySet() : droppedExceptionTypes;
        this.actorImpl = new UnmanagedBaseActor<Object>(name, config, connectionRegistry, mapper, retryStrategyFactory, exceptionHandlingFactory, clazz, this::handle, this::isExceptionIgnorable);
    }

    protected abstract boolean handle(Message var1) throws Exception;

    protected boolean isExceptionIgnorable(Throwable t) {
        return this.droppedExceptionTypes.stream().anyMatch(exceptionType -> ClassUtils.isAssignable(t.getClass(), (Class)exceptionType));
    }

    public final void publishWithDelay(Message message, long delayMilliseconds) throws Exception {
        this.actorImpl.publishWithDelay(message, delayMilliseconds);
    }

    public final void publish(Message message) throws Exception {
        this.publish(message, MessageProperties.MINIMAL_PERSISTENT_BASIC);
    }

    public final void publish(Message message, AMQP.BasicProperties properties) throws Exception {
        this.actorImpl.publish(message, properties);
    }

    public final long pendingMessagesCount() {
        return this.actorImpl.pendingMessagesCount();
    }

    public void start() throws Exception {
        this.actorImpl.start();
    }

    public void stop() throws Exception {
        this.actorImpl.stop();
    }

    public UnmanagedBaseActor<Message> getActorImpl() {
        return this.actorImpl;
    }

    public Set<Class<?>> getDroppedExceptionTypes() {
        return this.droppedExceptionTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseActor)) {
            return false;
        }
        BaseActor other = (BaseActor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnmanagedBaseActor<Message> this$actorImpl = this.getActorImpl();
        UnmanagedBaseActor<Message> other$actorImpl = other.getActorImpl();
        if (this$actorImpl == null ? other$actorImpl != null : !((Object)this$actorImpl).equals(other$actorImpl)) {
            return false;
        }
        Set<Class<?>> this$droppedExceptionTypes = this.getDroppedExceptionTypes();
        Set<Class<?>> other$droppedExceptionTypes = other.getDroppedExceptionTypes();
        return !(this$droppedExceptionTypes == null ? other$droppedExceptionTypes != null : !((Object)this$droppedExceptionTypes).equals(other$droppedExceptionTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseActor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnmanagedBaseActor<Message> $actorImpl = this.getActorImpl();
        result = result * 59 + ($actorImpl == null ? 43 : ((Object)$actorImpl).hashCode());
        Set<Class<?>> $droppedExceptionTypes = this.getDroppedExceptionTypes();
        result = result * 59 + ($droppedExceptionTypes == null ? 43 : ((Object)$droppedExceptionTypes).hashCode());
        return result;
    }

    public String toString() {
        return "BaseActor(actorImpl=" + this.getActorImpl() + ", droppedExceptionTypes=" + this.getDroppedExceptionTypes() + ")";
    }
}

