/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.actor;

import io.appform.dropwizard.actors.actor.ConsumerConfig;
import io.appform.dropwizard.actors.actor.DelayType;
import io.appform.dropwizard.actors.actor.ProducerConfig;
import io.appform.dropwizard.actors.exceptionhandler.config.ExceptionHandlerConfig;
import io.appform.dropwizard.actors.retry.config.NoRetryConfig;
import io.appform.dropwizard.actors.retry.config.RetryConfig;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ActorConfig {
    @NotNull
    @NotEmpty
    private String exchange;
    private boolean delayed;
    private DelayType delayType;
    @NotNull
    @NotEmpty
    private String prefix;
    @Min(value=1L)
    @Max(value=100L)
    private int concurrency;
    @Min(value=1L)
    @Max(value=100L)
    private int prefetchCount;
    @NotNull
    @Valid
    private RetryConfig retryConfig;
    private ExceptionHandlerConfig exceptionHandlerConfig;
    @Valid
    private ProducerConfig producer;
    @Valid
    private ConsumerConfig consumer;

    private static boolean $default$delayed() {
        return false;
    }

    private static DelayType $default$delayType() {
        return DelayType.DELAYED;
    }

    private static String $default$prefix() {
        return "rabbitmq.actors";
    }

    private static int $default$concurrency() {
        return 3;
    }

    private static int $default$prefetchCount() {
        return 1;
    }

    private static RetryConfig $default$retryConfig() {
        return new NoRetryConfig();
    }

    public static ActorConfigBuilder builder() {
        return new ActorConfigBuilder();
    }

    public String getExchange() {
        return this.exchange;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public DelayType getDelayType() {
        return this.delayType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public RetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    public ExceptionHandlerConfig getExceptionHandlerConfig() {
        return this.exceptionHandlerConfig;
    }

    public ProducerConfig getProducer() {
        return this.producer;
    }

    public ConsumerConfig getConsumer() {
        return this.consumer;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public void setDelayType(DelayType delayType) {
        this.delayType = delayType;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public void setExceptionHandlerConfig(ExceptionHandlerConfig exceptionHandlerConfig) {
        this.exceptionHandlerConfig = exceptionHandlerConfig;
    }

    public void setProducer(ProducerConfig producer) {
        this.producer = producer;
    }

    public void setConsumer(ConsumerConfig consumer) {
        this.consumer = consumer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActorConfig)) {
            return false;
        }
        ActorConfig other = (ActorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$exchange = this.getExchange();
        String other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
            return false;
        }
        if (this.isDelayed() != other.isDelayed()) {
            return false;
        }
        DelayType this$delayType = this.getDelayType();
        DelayType other$delayType = other.getDelayType();
        if (this$delayType == null ? other$delayType != null : !((Object)((Object)this$delayType)).equals((Object)other$delayType)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        if (this.getConcurrency() != other.getConcurrency()) {
            return false;
        }
        if (this.getPrefetchCount() != other.getPrefetchCount()) {
            return false;
        }
        RetryConfig this$retryConfig = this.getRetryConfig();
        RetryConfig other$retryConfig = other.getRetryConfig();
        if (this$retryConfig == null ? other$retryConfig != null : !((Object)this$retryConfig).equals(other$retryConfig)) {
            return false;
        }
        ExceptionHandlerConfig this$exceptionHandlerConfig = this.getExceptionHandlerConfig();
        ExceptionHandlerConfig other$exceptionHandlerConfig = other.getExceptionHandlerConfig();
        if (this$exceptionHandlerConfig == null ? other$exceptionHandlerConfig != null : !((Object)this$exceptionHandlerConfig).equals(other$exceptionHandlerConfig)) {
            return false;
        }
        ProducerConfig this$producer = this.getProducer();
        ProducerConfig other$producer = other.getProducer();
        if (this$producer == null ? other$producer != null : !((Object)this$producer).equals(other$producer)) {
            return false;
        }
        ConsumerConfig this$consumer = this.getConsumer();
        ConsumerConfig other$consumer = other.getConsumer();
        return !(this$consumer == null ? other$consumer != null : !((Object)this$consumer).equals(other$consumer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        result = result * 59 + (this.isDelayed() ? 79 : 97);
        DelayType $delayType = this.getDelayType();
        result = result * 59 + ($delayType == null ? 43 : ((Object)((Object)$delayType)).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        result = result * 59 + this.getConcurrency();
        result = result * 59 + this.getPrefetchCount();
        RetryConfig $retryConfig = this.getRetryConfig();
        result = result * 59 + ($retryConfig == null ? 43 : ((Object)$retryConfig).hashCode());
        ExceptionHandlerConfig $exceptionHandlerConfig = this.getExceptionHandlerConfig();
        result = result * 59 + ($exceptionHandlerConfig == null ? 43 : ((Object)$exceptionHandlerConfig).hashCode());
        ProducerConfig $producer = this.getProducer();
        result = result * 59 + ($producer == null ? 43 : ((Object)$producer).hashCode());
        ConsumerConfig $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : ((Object)$consumer).hashCode());
        return result;
    }

    public String toString() {
        return "ActorConfig(exchange=" + this.getExchange() + ", delayed=" + this.isDelayed() + ", delayType=" + (Object)((Object)this.getDelayType()) + ", prefix=" + this.getPrefix() + ", concurrency=" + this.getConcurrency() + ", prefetchCount=" + this.getPrefetchCount() + ", retryConfig=" + this.getRetryConfig() + ", exceptionHandlerConfig=" + this.getExceptionHandlerConfig() + ", producer=" + this.getProducer() + ", consumer=" + this.getConsumer() + ")";
    }

    public ActorConfig(String exchange, boolean delayed, DelayType delayType, String prefix, int concurrency, int prefetchCount, RetryConfig retryConfig, ExceptionHandlerConfig exceptionHandlerConfig, ProducerConfig producer, ConsumerConfig consumer) {
        this.exchange = exchange;
        this.delayed = delayed;
        this.delayType = delayType;
        this.prefix = prefix;
        this.concurrency = concurrency;
        this.prefetchCount = prefetchCount;
        this.retryConfig = retryConfig;
        this.exceptionHandlerConfig = exceptionHandlerConfig;
        this.producer = producer;
        this.consumer = consumer;
    }

    public ActorConfig() {
        this.delayed = ActorConfig.$default$delayed();
        this.delayType = ActorConfig.$default$delayType();
        this.prefix = ActorConfig.$default$prefix();
        this.concurrency = ActorConfig.$default$concurrency();
        this.prefetchCount = ActorConfig.$default$prefetchCount();
        this.retryConfig = ActorConfig.$default$retryConfig();
    }

    public static class ActorConfigBuilder {
        private String exchange;
        private boolean delayed$set;
        private boolean delayed;
        private boolean delayType$set;
        private DelayType delayType;
        private boolean prefix$set;
        private String prefix;
        private boolean concurrency$set;
        private int concurrency;
        private boolean prefetchCount$set;
        private int prefetchCount;
        private boolean retryConfig$set;
        private RetryConfig retryConfig;
        private ExceptionHandlerConfig exceptionHandlerConfig;
        private ProducerConfig producer;
        private ConsumerConfig consumer;

        ActorConfigBuilder() {
        }

        public ActorConfigBuilder exchange(String exchange) {
            this.exchange = exchange;
            return this;
        }

        public ActorConfigBuilder delayed(boolean delayed) {
            this.delayed = delayed;
            this.delayed$set = true;
            return this;
        }

        public ActorConfigBuilder delayType(DelayType delayType) {
            this.delayType = delayType;
            this.delayType$set = true;
            return this;
        }

        public ActorConfigBuilder prefix(String prefix) {
            this.prefix = prefix;
            this.prefix$set = true;
            return this;
        }

        public ActorConfigBuilder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrency$set = true;
            return this;
        }

        public ActorConfigBuilder prefetchCount(int prefetchCount) {
            this.prefetchCount = prefetchCount;
            this.prefetchCount$set = true;
            return this;
        }

        public ActorConfigBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            this.retryConfig$set = true;
            return this;
        }

        public ActorConfigBuilder exceptionHandlerConfig(ExceptionHandlerConfig exceptionHandlerConfig) {
            this.exceptionHandlerConfig = exceptionHandlerConfig;
            return this;
        }

        public ActorConfigBuilder producer(ProducerConfig producer) {
            this.producer = producer;
            return this;
        }

        public ActorConfigBuilder consumer(ConsumerConfig consumer) {
            this.consumer = consumer;
            return this;
        }

        public ActorConfig build() {
            boolean delayed = this.delayed;
            if (!this.delayed$set) {
                delayed = ActorConfig.$default$delayed();
            }
            DelayType delayType = this.delayType;
            if (!this.delayType$set) {
                delayType = ActorConfig.$default$delayType();
            }
            String prefix = this.prefix;
            if (!this.prefix$set) {
                prefix = ActorConfig.$default$prefix();
            }
            int concurrency = this.concurrency;
            if (!this.concurrency$set) {
                concurrency = ActorConfig.$default$concurrency();
            }
            int prefetchCount = this.prefetchCount;
            if (!this.prefetchCount$set) {
                prefetchCount = ActorConfig.$default$prefetchCount();
            }
            RetryConfig retryConfig = this.retryConfig;
            if (!this.retryConfig$set) {
                retryConfig = ActorConfig.$default$retryConfig();
            }
            return new ActorConfig(this.exchange, delayed, delayType, prefix, concurrency, prefetchCount, retryConfig, this.exceptionHandlerConfig, this.producer, this.consumer);
        }

        public String toString() {
            return "ActorConfig.ActorConfigBuilder(exchange=" + this.exchange + ", delayed=" + this.delayed + ", delayType=" + (Object)((Object)this.delayType) + ", prefix=" + this.prefix + ", concurrency=" + this.concurrency + ", prefetchCount=" + this.prefetchCount + ", retryConfig=" + this.retryConfig + ", exceptionHandlerConfig=" + this.exceptionHandlerConfig + ", producer=" + this.producer + ", consumer=" + this.consumer + ")";
        }
    }
}

