/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors;

import io.appform.dropwizard.actors.ExecutorServiceProvider;
import io.appform.dropwizard.actors.common.RabbitmqActorException;
import io.appform.dropwizard.actors.config.RMQConfig;
import io.appform.dropwizard.actors.connectivity.ConnectionConfig;
import io.appform.dropwizard.actors.connectivity.RMQConnection;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionRegistry
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(ConnectionRegistry.class);
    private final ConcurrentHashMap<String, RMQConnection> connections;
    private final Environment environment;
    private final ExecutorServiceProvider executorServiceProvider;
    private final RMQConfig rmqConfig;

    public ConnectionRegistry(Environment environment, ExecutorServiceProvider executorServiceProvider, RMQConfig rmqConfig) {
        this.environment = environment;
        this.executorServiceProvider = executorServiceProvider;
        this.rmqConfig = rmqConfig;
        this.connections = new ConcurrentHashMap();
    }

    public RMQConnection createOrGet(String connectionName) {
        int threadPoolSize = this.determineThreadPoolSize(connectionName);
        return this.createOrGet(connectionName, threadPoolSize);
    }

    public RMQConnection createOrGet(String connectionName, int threadPoolSize) {
        return this.connections.computeIfAbsent(connectionName, connection -> {
            log.info(String.format("Creating new RMQ connection with name [%s] having [%d] threads", connection, threadPoolSize));
            RMQConnection rmqConnection = new RMQConnection((String)connection, this.rmqConfig, this.executorServiceProvider.newFixedThreadPool(String.format("rmqconnection-%s", connection), threadPoolSize), this.environment);
            try {
                rmqConnection.start();
            }
            catch (Exception e) {
                throw RabbitmqActorException.propagate(e);
            }
            log.info(String.format("Created new RMQ connection with name [%s]", connection));
            return rmqConnection;
        });
    }

    private int determineThreadPoolSize(String connectionName) {
        if (this.rmqConfig.getConnections() == null) {
            return 10;
        }
        return this.rmqConfig.getConnections().stream().filter(x -> Objects.equals(x.getName(), connectionName)).findAny().map(ConnectionConfig::getThreadPoolSize).orElse(10);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.connections.forEach(new BiConsumer<String, RMQConnection>(){

            @Override
            public void accept(String name, RMQConnection rmqConnection) {
                rmqConnection.stop();
            }
        });
    }

    public ConcurrentHashMap<String, RMQConnection> getConnections() {
        return this.connections;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ExecutorServiceProvider getExecutorServiceProvider() {
        return this.executorServiceProvider;
    }

    public RMQConfig getRmqConfig() {
        return this.rmqConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionRegistry)) {
            return false;
        }
        ConnectionRegistry other = (ConnectionRegistry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentHashMap<String, RMQConnection> this$connections = this.getConnections();
        ConcurrentHashMap<String, RMQConnection> other$connections = other.getConnections();
        if (this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        ExecutorServiceProvider this$executorServiceProvider = this.getExecutorServiceProvider();
        ExecutorServiceProvider other$executorServiceProvider = other.getExecutorServiceProvider();
        if (this$executorServiceProvider == null ? other$executorServiceProvider != null : !this$executorServiceProvider.equals(other$executorServiceProvider)) {
            return false;
        }
        RMQConfig this$rmqConfig = this.getRmqConfig();
        RMQConfig other$rmqConfig = other.getRmqConfig();
        return !(this$rmqConfig == null ? other$rmqConfig != null : !((Object)this$rmqConfig).equals(other$rmqConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionRegistry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentHashMap<String, RMQConnection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        ExecutorServiceProvider $executorServiceProvider = this.getExecutorServiceProvider();
        result = result * 59 + ($executorServiceProvider == null ? 43 : $executorServiceProvider.hashCode());
        RMQConfig $rmqConfig = this.getRmqConfig();
        result = result * 59 + ($rmqConfig == null ? 43 : ((Object)$rmqConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionRegistry(connections=" + this.getConnections() + ", environment=" + this.getEnvironment() + ", executorServiceProvider=" + this.getExecutorServiceProvider() + ", rmqConfig=" + this.getRmqConfig() + ")";
    }
}

