/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.retry.impl;

import com.github.rholder.retry.BlockStrategies;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import io.appform.dropwizard.actors.retry.RetryStrategy;
import io.appform.dropwizard.actors.retry.config.TimeLimitedExponentialWaitRetryConfig;
import io.appform.dropwizard.actors.utils.CommonUtils;
import java.util.concurrent.TimeUnit;

public class TimeLimitedExponentialWaitRetryStrategy
extends RetryStrategy {
    public TimeLimitedExponentialWaitRetryStrategy(TimeLimitedExponentialWaitRetryConfig config) {
        super((Retryer<Boolean>)RetryerBuilder.newBuilder().retryIfException(exception -> CommonUtils.isRetriable(config.getRetriableExceptions(), exception)).withStopStrategy(StopStrategies.stopAfterDelay((long)config.getMaxTime().toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS)).withBlockStrategy(BlockStrategies.threadSleepStrategy()).withWaitStrategy(WaitStrategies.exponentialWait((long)config.getMultipier(), (long)config.getMaxTimeBetweenRetries().toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS)).build());
    }
}

