/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.actor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.appform.dropwizard.actors.actor.ActorConfig;
import io.appform.dropwizard.actors.actor.BaseActor;
import io.appform.dropwizard.actors.connectivity.RMQConnection;
import io.appform.dropwizard.actors.retry.RetryStrategyFactory;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Actor<MessageType extends Enum<MessageType>, Message>
extends BaseActor<Message> {
    private static final Logger log = LoggerFactory.getLogger(Actor.class);
    private MessageType type;

    protected Actor(MessageType type, ActorConfig config, RMQConnection connection, ObjectMapper mapper, RetryStrategyFactory retryStrategyFactory, Class<? extends Message> clazz, Set<Class<?>> droppedExceptionTypes) {
        super(((Enum)type).name(), config, connection, mapper, retryStrategyFactory, clazz, droppedExceptionTypes);
        this.type = type;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Actor)) {
            return false;
        }
        Actor other = (Actor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Actor;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Actor(super=" + super.toString() + ", type=" + this.getType() + ")";
    }
}

