/*
 * Decompiled with CFR 0.152.
 */
package io.appform.core.hystrix;

import com.hystrix.configurator.core.HystrixConfigurationFactory;
import io.appform.core.hystrix.GenericHystrixCommand;
import java.util.UUID;

public class CommandFactory {
    public static <R> GenericHystrixCommand<R> create(String group, String command, String traceId) {
        return new GenericHystrixCommand(HystrixConfigurationFactory.getCommandConfiguration((String)CommandFactory.commandKey(group, command)), traceId, command);
    }

    public static <R> GenericHystrixCommand<R> create(String group, String command) {
        return CommandFactory.create(group, command, UUID.randomUUID().toString().replaceAll("-", ""));
    }

    private static String commandKey(String group, String command) {
        return String.format("%s.%s", group, command);
    }

    private CommandFactory() {
    }
}

