/*
 * Decompiled with CFR 0.152.
 */
package io.appform.core.hystrix;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingHandler {
    private static final Logger log = LoggerFactory.getLogger(TracingHandler.class);

    public static Tracer getTracer() {
        try {
            return GlobalTracer.get();
        }
        catch (Exception e) {
            log.error("Error while getting tracer", (Throwable)e);
            return null;
        }
    }

    public static Span getParentActiveSpan(Tracer tracer) {
        try {
            return tracer == null ? null : tracer.activeSpan();
        }
        catch (Exception e) {
            log.error("Error while getting activeSpan", (Throwable)e);
            return null;
        }
    }

    public static Span startChildSpan(Tracer tracer, Span parentSpan, String command) {
        try {
            if (tracer == null || parentSpan == null) {
                return null;
            }
            return tracer.buildSpan("hystrix").asChildOf(parentSpan).withTag("hystrix.command", command).start();
        }
        catch (Exception e) {
            log.error("Error while starting child span", (Throwable)e);
            return null;
        }
    }

    public static Scope activateSpan(Tracer tracer, Span span) {
        try {
            if (tracer == null || span == null) {
                return null;
            }
            return tracer.activateSpan(span);
        }
        catch (Exception e) {
            log.error("Error while activating span", (Throwable)e);
            return null;
        }
    }

    public static void closeScopeAndSpan(Span span, Scope scope) {
        try {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.finish();
            }
        }
        catch (Exception e) {
            log.error("Error while closing span and scope", (Throwable)e);
        }
    }
}

