/*
 * Decompiled with CFR 0.152.
 */
package io.appform.core.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandProperties;
import io.appform.core.hystrix.HandlerAdapter;
import io.appform.core.hystrix.TracingHandler;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Map;
import org.slf4j.MDC;

public class GenericHystrixCommand<R> {
    private static final String TRACE_ID = "TRACE-ID";
    private final HystrixCommand.Setter setter;
    private final String traceId;
    private final String command;

    public GenericHystrixCommand(HystrixCommand.Setter setter, String traceId, String command) {
        this.setter = setter;
        this.traceId = traceId;
        this.command = command;
    }

    public HystrixCommand<R> executor(final HandlerAdapter<R> function) {
        final Map parentMDCContext = MDC.getCopyOfContextMap();
        final Tracer tracer = TracingHandler.getTracer();
        final Span parentActiveSpan = TracingHandler.getParentActiveSpan(tracer);
        return new HystrixCommand<R>(this.setter){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected R run() throws Exception {
                if (parentMDCContext != null) {
                    MDC.setContextMap((Map)parentMDCContext);
                }
                Span span = TracingHandler.startChildSpan(tracer, parentActiveSpan, GenericHystrixCommand.this.command);
                Scope scope = TracingHandler.activateSpan(tracer, span);
                MDC.put((String)GenericHystrixCommand.TRACE_ID, (String)GenericHystrixCommand.this.traceId);
                try {
                    Object t = function.run();
                    return t;
                }
                finally {
                    TracingHandler.closeScopeAndSpan(span, scope);
                    HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy = (HystrixCommandProperties.ExecutionIsolationStrategy)this.getProperties().executionIsolationStrategy().get();
                    if (isolationStrategy == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
                        MDC.remove((String)GenericHystrixCommand.TRACE_ID);
                    } else {
                        MDC.clear();
                    }
                }
            }
        };
    }
}

