/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.samples.hadoop;

import io.apigee.trireme.samples.hadoop.HadoopBase;
import io.apigee.trireme.samples.hadoop.HadoopContext;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class HadoopMapper
extends HadoopBase
implements Mapper<LongWritable, Text, Text, Text> {
    private boolean running;
    private Function mapFunc;

    private void initialize() throws IOException {
        try {
            System.out.println("map: starting script");
            this.startNodeModule();
            Object mapObj = ScriptableObject.getProperty((Scriptable)this.module, (String)"map");
            if (mapObj == null || Context.getUndefinedValue().equals(mapObj) || !(mapObj instanceof Function)) {
                System.err.println("Nothing to map");
            } else {
                this.mapFunc = (Function)mapObj;
            }
            HadoopContext.initialize(this.module.getParentScope());
            this.running = true;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void map(LongWritable key, Text value, OutputCollector<Text, Text> out, Reporter reporter) throws IOException {
        if (!this.running) {
            this.initialize();
        }
        if (this.mapFunc == null) {
            return;
        }
        HadoopContext ctx = HadoopContext.createObject(this.module, out, null);
        this.runningScript.getRuntime().enqueueCallback(this.mapFunc, this.module, this.module, new Object[]{ctx, value.toString()});
        try {
            ctx.await();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public void close() {
        System.out.println("map.close: stopping script");
        this.stopNodeModule();
    }
}

