/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.samples.hadoop;

import io.apigee.trireme.samples.hadoop.HadoopMapper;
import io.apigee.trireme.samples.hadoop.HadoopReducer;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class HadoopMain {
    private JobConf conf;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: HadoopMain <input dir> <output dir> <script file>");
            return;
        }
        try {
            HadoopMain main = new HadoopMain();
            main.initializeHadoop();
            main.start(args[0], args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private HadoopMain() {
    }

    private void initializeHadoop() {
        this.conf = new JobConf(HadoopMain.class);
        this.conf.setJobName("noderunnersample");
        this.conf.setOutputKeyClass(Text.class);
        this.conf.setOutputValueClass(Text.class);
        this.conf.setInputFormat(TextInputFormat.class);
        this.conf.setOutputFormat(TextOutputFormat.class);
        this.conf.setMapperClass(HadoopMapper.class);
        this.conf.setReducerClass(HadoopReducer.class);
    }

    private void start(String inputDir, String outputDir, String scriptFileName) throws IOException {
        this.conf.set("ScriptFile", scriptFileName);
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{new Path(inputDir)});
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)new Path(outputDir));
        JobClient.runJob((JobConf)this.conf);
    }
}

