/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.samples.hadoop;

import io.apigee.trireme.core.Utils;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class HadoopContext
extends ScriptableObject {
    public static final String CLASS_NAME = "HadoopContext";
    private OutputCollector<Text, Text> collector;
    private Iterator<Text> values;
    private final CountDownLatch doneLatch = new CountDownLatch(1);

    public static void initialize(Scriptable scope) throws Exception {
        Context.enter();
        try {
            ScriptableObject.defineClass((Scriptable)scope, HadoopContext.class);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HadoopContext createObject(Scriptable scope, OutputCollector<Text, Text> collector, Iterator<Text> values) {
        Context cx = Context.enter();
        try {
            HadoopContext ctx = (HadoopContext)cx.newObject(scope, CLASS_NAME);
            ctx.init(collector, values);
            HadoopContext hadoopContext = ctx;
            return hadoopContext;
        }
        finally {
            Context.exit();
        }
    }

    public void await() throws InterruptedException {
        this.doneLatch.await();
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    private void init(OutputCollector<Text, Text> collector, Iterator<Text> values) {
        this.collector = collector;
        this.values = values;
    }

    @JSFunction
    public static void collect(Context cx, Scriptable thisObj, Object[] args, Function func) {
        if (args.length != 2) {
            throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"Two arguments expected");
        }
        if (!(args[0] instanceof String)) {
            throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"key must be a string");
        }
        if (!(args[1] instanceof String)) {
            throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"value must be a string");
        }
        HadoopContext self = (HadoopContext)thisObj;
        try {
            self.collector.collect((Object)new Text((String)args[0]), (Object)new Text((String)args[1]));
        }
        catch (IOException ioe) {
            throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)("Error on collection: " + ioe));
        }
    }

    @JSFunction
    public Object nextValue() {
        if (this.values == null || !this.values.hasNext()) {
            return null;
        }
        Text t = this.values.next();
        return t == null ? null : t.toString();
    }

    @JSFunction
    public static void done(Context cx, Scriptable thisObj, Object[] args, Function func) {
        HadoopContext self = (HadoopContext)thisObj;
        self.doneLatch.countDown();
    }
}

