/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.samples.hadoop;

import io.apigee.trireme.core.NodeEnvironment;
import io.apigee.trireme.core.NodeException;
import io.apigee.trireme.core.NodeScript;
import io.apigee.trireme.core.ScriptFuture;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.mozilla.javascript.Scriptable;

public class HadoopBase
extends MapReduceBase {
    public static final String SCRIPT_FILE_KEY = "ScriptFile";
    protected ScriptFuture runningScript;
    protected String scriptFileName;
    protected Scriptable module;
    protected NodeEnvironment env = new NodeEnvironment();

    public void configure(JobConf conf) {
        super.configure(conf);
        this.scriptFileName = conf.get(SCRIPT_FILE_KEY);
    }

    protected void startNodeModule() throws NodeException, InterruptedException, ExecutionException {
        File scriptFile = new File(this.scriptFileName);
        NodeScript script = this.env.createScript(scriptFile.getName(), scriptFile, null);
        this.runningScript = script.executeModule();
        this.module = this.runningScript.getModuleResult();
    }

    protected void stopNodeModule() {
        if (this.runningScript != null) {
            this.runningScript.cancel(true);
        }
    }
}

