/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.samples.hadoop;

import io.apigee.trireme.samples.hadoop.HadoopBase;
import io.apigee.trireme.samples.hadoop.HadoopContext;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopReducer
extends HadoopBase
implements Reducer<Text, Text, Text, Text> {
    private boolean running;
    private Function reduceFunc;

    private void initialize() throws IOException {
        try {
            System.out.println("reduce: starting script");
            this.startNodeModule();
            Object reduceObj = ScriptableObject.getProperty((Scriptable)this.module, (String)"reduce");
            if (reduceObj == null || Context.getUndefinedValue().equals(reduceObj) || !(reduceObj instanceof Function)) {
                System.err.println("Nothing to reduce");
            } else {
                this.reduceFunc = (Function)reduceObj;
            }
            HadoopContext.initialize(this.module.getParentScope());
            this.running = true;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> out, Reporter reporter) throws IOException {
        if (!this.running) {
            this.initialize();
        }
        if (this.reduceFunc == null) {
            return;
        }
        HadoopContext ctx = HadoopContext.createObject(this.module, out, values);
        this.runningScript.getRuntime().enqueueCallback(this.reduceFunc, this.module, this.module, new Object[]{ctx, key.toString()});
        try {
            ctx.await();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public void close() {
        System.out.println("map.close: stopping script");
        this.stopNodeModule();
    }
}

