/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11Nio2Protocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class TomcatConnector {
    private static Logger log = Red5LoggerFactory.getLogger(TomcatConnector.class);
    private Connector connector;
    private Map<String, String> connectionProperties;
    private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
    private InetSocketAddress address;
    private int redirectPort = 443;
    private boolean useIPVHosts = true;
    private String URIEncoding = "UTF-8";
    private boolean secure;
    private boolean initialized;

    public void init() {
        try {
            ProtocolHandler handler;
            this.connector = new Connector(this.protocol);
            this.connector.setRedirectPort(this.redirectPort);
            this.connector.setUseIPVHosts(this.useIPVHosts);
            this.connector.setURIEncoding(this.URIEncoding);
            if (this.address == null) {
                this.address = this.bindLocal(this.connector.getPort());
            }
            this.connector.setPort(this.address.getPort());
            if (this.connectionProperties != null) {
                for (String key : this.connectionProperties.keySet()) {
                    this.connector.setProperty(key, this.connectionProperties.get(key));
                }
            }
            AprLifecycleListener listener = new AprLifecycleListener();
            listener.setUseAprConnector(false);
            listener.setUseOpenSSL(true);
            listener.setSSLEngine("off");
            this.connector.addLifecycleListener((LifecycleListener)listener);
            if (this.secure) {
                listener.setSSLEngine("on");
                this.connector.setSecure(true);
                this.connector.setScheme("https");
            }
            if ((handler = this.connector.getProtocolHandler()) instanceof Http11Nio2Protocol) {
                ((Http11Nio2Protocol)handler).setAddress(this.address.getAddress());
            } else if (handler instanceof Http11NioProtocol) {
                ((Http11NioProtocol)handler).setAddress(this.address.getAddress());
            } else if (handler instanceof Http11AprProtocol) {
                ((Http11AprProtocol)handler).setAddress(this.address.getAddress());
            }
            this.initialized = true;
        }
        catch (Throwable t) {
            log.error("Exception during connector creation", t);
        }
    }

    private InetSocketAddress bindLocal(int port) throws Exception {
        return new InetSocketAddress("127.0.0.1", port);
    }

    public Connector getConnector() {
        if (!this.initialized) {
            this.init();
        }
        return this.connector;
    }

    public void setConnectionProperties(Map<String, String> props) {
        if (this.connectionProperties == null) {
            this.connectionProperties = new HashMap<String, String>();
        }
        this.connectionProperties.putAll(props);
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.useIPVHosts = useIPVHosts;
    }

    public void setURIEncoding(String uRIEncoding) {
        this.URIEncoding = uRIEncoding;
    }

    public void setAddress(String addressAndPort) {
        try {
            String addr = "0.0.0.0";
            int port = 5080;
            if (addressAndPort != null && addressAndPort.indexOf(58) != -1) {
                String[] parts = addressAndPort.split(":");
                addr = parts[0];
                port = Integer.valueOf(parts[1]);
            }
            this.address = new InetSocketAddress(addr, port);
        }
        catch (Exception e) {
            log.warn("Exception configuring address", (Throwable)e);
        }
    }

    public String getAddress() {
        return String.format("%s:%d", this.address.getHostName(), this.address.getPort());
    }

    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String toString() {
        return "TomcatConnector [connector=" + this.connector + ", connectionProperties=" + this.connectionProperties + ", address=" + this.address + "]";
    }
}

