/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.red5.server.jmx.mxbeans.LoaderMXBean;
import org.red5.server.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class WarDeployer
implements InitializingBean,
DisposableBean {
    private Logger log = LoggerFactory.getLogger(WarDeployer.class);
    private static AtomicBoolean deploying = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<DeployJob> future;
    private int checkInterval = 600000;
    private String webappFolder;
    private boolean expandWars;

    public WarDeployer() {
        this.log.info("War deployer service created");
    }

    public void afterPropertiesSet() throws Exception {
        this.log.info("Starting WarDeployer");
        this.future = this.scheduler.scheduleAtFixedRate(new DeployJob(), 60000L, this.checkInterval, TimeUnit.MILLISECONDS);
        this.log.debug("Webapps directory: {}", (Object)this.webappFolder);
        File dir = new File(this.webappFolder);
        if (!dir.exists()) {
            this.log.warn("Source directory not found");
        } else if (!dir.isDirectory()) {
            throw new Exception("Webapps directory is not a directory");
        }
        dir = null;
        if (this.expandWars) {
            this.log.debug("Deploying wars");
            this.deploy(false);
        }
    }

    private void deploy(boolean startApplication) {
        this.log.info("Deploy wars {} app start", (Object)(startApplication ? "with" : "without"));
        if (deploying.compareAndSet(false, true)) {
            File[] files;
            String application = null;
            String applicationWarName = null;
            File dir = new File(this.webappFolder);
            for (File f : files = dir.listFiles(new DirectoryFilter())) {
                applicationWarName = f.getName();
                int dashIndex = applicationWarName.indexOf(45);
                application = dashIndex != -1 ? applicationWarName.substring(0, dashIndex) : applicationWarName.substring(0, applicationWarName.lastIndexOf(46));
                this.log.debug("Application name: {}", (Object)application);
                String contextPath = "/" + application;
                String contextDir = this.webappFolder + contextPath;
                this.log.debug("Web context: {} context directory: {}", (Object)contextPath, (Object)contextDir);
                File appDir = new File(dir, application);
                if (appDir.exists()) {
                    if (appDir.isDirectory()) {
                        this.log.debug("Application directory exists");
                    } else {
                        this.log.warn("Application destination is not a directory");
                    }
                    this.log.info("Application {} already installed, please un-install before attempting another install", (Object)application);
                } else {
                    File warFile;
                    LoaderMXBean loader;
                    this.log.debug("Unwaring and starting...");
                    FileUtil.unzip((String)(this.webappFolder + "/" + applicationWarName), (String)contextDir);
                    if (startApplication && (loader = this.getLoader()) != null) {
                        try {
                            loader.startWebApplication(application);
                        }
                        catch (ServletException e) {
                            this.log.error("Unexpected error while staring web application", (Throwable)e);
                        }
                    }
                    if ((warFile = new File(dir, applicationWarName)).delete()) {
                        this.log.debug("{} was deleted", (Object)warFile.getName());
                    } else {
                        this.log.debug("{} was not deleted", (Object)warFile.getName());
                        warFile.deleteOnExit();
                    }
                    warFile = null;
                }
                appDir = null;
            }
            dir = null;
            deploying.set(false);
        }
    }

    public void destroy() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.scheduler.shutdownNow();
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public String getWebappFolder() {
        return this.webappFolder;
    }

    public void setWebappFolder(String webappFolder) {
        this.webappFolder = webappFolder;
    }

    public void setExpandWars(boolean expandWars) {
        this.expandWars = expandWars;
    }

    public LoaderMXBean getLoader() {
        LoaderMXBean loader = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oName = new ObjectName("org.red5.server:type=TomcatLoader");
            if (mbs.isRegistered(oName)) {
                loader = JMX.newMXBeanProxy(mbs, oName, LoaderMXBean.class, true);
                this.log.debug("Loader was found");
            } else {
                this.log.warn("Loader not found");
            }
        }
        catch (Exception e) {
            this.log.error("Exception getting loader", (Throwable)e);
        }
        return loader;
    }

    private class DeployJob
    implements Runnable {
        private DeployJob() {
        }

        @Override
        public void run() {
            WarDeployer.this.log.debug("Starting scheduled deployment of wars");
            WarDeployer.this.deploy(true);
        }
    }

    protected class DirectoryFilter
    implements FilenameFilter {
        protected DirectoryFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            WarDeployer.this.log.trace("Filtering: {} name: {}", (Object)dir.getName(), (Object)name);
            boolean result = f.getName().endsWith("war");
            f = null;
            return result;
        }
    }
}

