/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utility.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class LongUtils {
    private static final XLogger logger = XLoggerFactory.getXLogger(LongUtils.class);
    private static final Pattern LONG_PATTERN = Pattern.compile("-??\\d+");

    private LongUtils() {
    }

    public static Long tryParseLong(String text) {
        Matcher matcher;
        Long value = null;
        if (StringUtils.isNotBlank((CharSequence)text) && (matcher = LONG_PATTERN.matcher(text = text.trim())).matches()) {
            value = Long.valueOf(text);
        }
        if (value == null) {
            logger.warn("There was an error trying to parse {0}", (Object)text);
        }
        return value;
    }

    public static Long tryParseLong(String text, Long defaultValue) {
        Long value = LongUtils.tryParseLong(text);
        return value == null ? defaultValue : value;
    }

    public static Long getValue(Long number) {
        Long value = 0L;
        if (number != null) {
            value = number;
        }
        return value;
    }
}

