/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class TelephoneStringSerializer
extends StringSerializer {
    private static final int PHONE_NUMBER_LENGTH = 10;
    private static final int PHONE_AREA_CODE_INDEX = 0;
    private static final int PHONE_PREFIX_INDEX = 3;
    private static final int PHONE_LINE_NUMBER_INDEX = 6;

    public void serialize(String text, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeObject((Object)this.serialize(text));
    }

    @Override
    public String serialize(String text) {
        Object phoneNumber = text.trim();
        if (StringUtils.isNotBlank((CharSequence)phoneNumber) && ((String)phoneNumber).length() == 10 && ((String)phoneNumber).matches("\\d{10}")) {
            String areaCode = ((String)phoneNumber).substring(0, 3);
            String phonePrefix = ((String)phoneNumber).substring(3, 6);
            String lineNumber = ((String)phoneNumber).substring(6);
            phoneNumber = "(" + areaCode + ") " + phonePrefix + "-" + lineNumber;
        }
        return phoneNumber;
    }
}

