/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.date.DateFormat;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Instant2LocalDateTimeStringSerializer
extends StringSerializer {
    public void serialize(String text, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeObject((Object)this.serialize(text));
    }

    @Override
    public String serialize(String text) {
        DateTimeFormatter originalFormatter = DateTimeFormatter.ofPattern(DateFormat.ISO_INSTANT.getValue());
        LocalDateTime originalDateTime = LocalDateTime.parse(text, originalFormatter);
        DateTimeFormatter convertedFormatter = DateTimeFormatter.ofPattern(DateFormat.ISO_TIME.getValue());
        return originalDateTime.format(convertedFormatter);
    }
}

