/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.io;

import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;

public class IOUtils {
    private static final XLogger LOGGER = XLoggerFactory.getXLogger(IOUtils.class);

    private IOUtils() {
    }

    public static String readFileToAString(String fileName) {
        String text;
        try (InputStreamReader reader = new InputStreamReader(new ClassPathResource(fileName).getInputStream());){
            text = FileCopyUtils.copyToString((Reader)reader);
        }
        catch (IOException ioException) {
            throw new ApplicationServerException((Throwable)ioException);
        }
        return text;
    }

    static void writeStringToAFile(String fileName, String text, OpenOption ... openOptions) {
        Path path = Paths.get(fileName, new String[0]);
        String messageFormat = MessageFormat.format("File path: {0}", path.toFile().getAbsolutePath());
        LOGGER.info(messageFormat);
        try {
            Files.write(path, text.getBytes(), openOptions);
        }
        catch (IOException ioException) {
            throw new ApplicationServerException((Throwable)ioException);
        }
    }

    public static void appendStringToAFile(String fileName, String text) {
        IOUtils.writeStringToAFile(fileName, text, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    public static List<String> getStringsFromFile(String fileName) {
        ArrayList<String> arrayList;
        ClassPathResource resource = new ClassPathResource(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new ApplicationServerException((Throwable)exception);
            }
        }
        reader.close();
        return arrayList;
    }

    public static byte[] compressBytes(byte[] data) {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] compressedBytes = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            compressedBytes = outputStream.toByteArray();
        }
        catch (IOException exception) {
            LOGGER.catching((Throwable)exception);
        }
        return compressedBytes;
    }

    public static byte[] decompressBytes(byte[] data) {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        byte[] compressedBytes = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            int count = 0;
            while (!inflater.finished()) {
                count = IOUtils.getCount(inflater, buffer);
                outputStream.write(buffer, 0, count);
            }
            compressedBytes = outputStream.toByteArray();
        }
        catch (IOException exception) {
            LOGGER.catching((Throwable)exception);
        }
        return compressedBytes;
    }

    private static int getCount(Inflater inflater, byte[] buffer) {
        int count = 0;
        try {
            count = inflater.inflate(buffer);
        }
        catch (DataFormatException exception) {
            LOGGER.catching((Throwable)exception);
        }
        return count;
    }
}

