/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.date;

import io.americanexpress.synapse.utilities.common.date.DateTimeUtils;
import io.americanexpress.synapse.utilities.common.date.DateUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class OffsetDateTimeUtils {
    public static final String UTC_OFFSET = "+00:00";
    public static final String UTC_LITERAL_Z = "Z";
    public static final Pattern ISO8601_OFFSET_DATE_TIME_PATTERN = Pattern.compile("^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01](?:[0-7]:[0-5]\\d|8:00))$");
    public static final Pattern ISO8601_OFFSET_PATTERN = Pattern.compile("^(?:Z|[+-][01](?:[0-7]:[0-5]\\d|8:00))$");

    private OffsetDateTimeUtils() {
    }

    public static boolean isIso8601OffsetDateTime(String offsetDateTime) {
        return StringUtils.isNotBlank((CharSequence)offsetDateTime) && ISO8601_OFFSET_DATE_TIME_PATTERN.matcher(offsetDateTime).matches();
    }

    public static boolean isIso8601Offset(String offset) {
        return StringUtils.isNotBlank((CharSequence)offset) && ISO8601_OFFSET_PATTERN.matcher(offset).matches();
    }

    public static String convertToIso8601OffsetDateTime(String dateTimeValue) {
        return OffsetDateTimeUtils.convertToIso8601OffsetDateTime(dateTimeValue, UTC_OFFSET);
    }

    public static String convertToIso8601OffsetDateTime(String dateTimeValue, String offset) {
        Object formattedOffsetDateTime;
        Object object = formattedOffsetDateTime = StringUtils.indexOf((CharSequence)dateTimeValue, (CharSequence)" ") == 10 ? StringUtils.replaceOnce((String)dateTimeValue, (String)" ", (String)"T") : dateTimeValue;
        if ((DateUtils.isIso8601Date((String)formattedOffsetDateTime) || DateTimeUtils.isIso8601DateTime((String)formattedOffsetDateTime)) && OffsetDateTimeUtils.isIso8601Offset(offset)) {
            formattedOffsetDateTime = DateTimeUtils.convertToIso8601DateTime((String)formattedOffsetDateTime) + offset;
        }
        return formattedOffsetDateTime;
    }
}

