/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.date;

import io.americanexpress.synapse.utilities.common.date.DateUtils;
import io.americanexpress.synapse.utilities.common.date.OffsetDateTimeUtils;
import io.americanexpress.synapse.utilities.common.date.TimeUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtils {
    public static final String ISO_8601_DATE_TIME_LITERAL_T = "T";
    public static final String MIDNIGHT_ISO_8601_TIME = "00:00:00.000";
    public static final Pattern ISO8601_DATE_TIME_PATTERN = Pattern.compile("^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?$");

    private DateTimeUtils() {
    }

    public static boolean isIso8601DateTime(String dateTime) {
        return StringUtils.isNotBlank((CharSequence)dateTime) && ISO8601_DATE_TIME_PATTERN.matcher(dateTime).matches();
    }

    public static String convertToIso8601DateTime(String dateTimeValue) {
        return DateTimeUtils.convertToIso8601DateTime(dateTimeValue, MIDNIGHT_ISO_8601_TIME);
    }

    public static String convertToIso8601DateTime(String dateTimeValue, String time) {
        Object formattedDateTime = dateTimeValue;
        if (DateUtils.isIso8601Date((String)formattedDateTime) && TimeUtils.isIso8601Time(time)) {
            formattedDateTime = (String)formattedDateTime + ISO_8601_DATE_TIME_LITERAL_T + time;
        }
        return formattedDateTime;
    }

    public static boolean isIso8601DateTimeFormat(String dateTimeValue) {
        return DateUtils.isIso8601Date(dateTimeValue) || DateTimeUtils.isIso8601DateTime(dateTimeValue) || OffsetDateTimeUtils.isIso8601OffsetDateTime(dateTimeValue);
    }
}

