/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.telephones;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class TelephoneUtil {
    private static final Pattern INTERNATIONAL_NUMBERING_PLAN_PATTERN = Pattern.compile("\\d{7,15}");

    private TelephoneUtil() {
    }

    public static boolean isPossibleTelephoneNumber(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        String telephoneNumber = text.replaceAll("\\D", "");
        if (StringUtils.isBlank((CharSequence)telephoneNumber)) {
            return false;
        }
        return INTERNATIONAL_NUMBERING_PLAN_PATTERN.matcher(telephoneNumber).matches();
    }

    public static boolean isPossibleNorthAmericanTelephoneNumber(String telephoneNumber) {
        int telephoneNumberLength = telephoneNumber.length();
        return telephoneNumberLength == 10 || telephoneNumberLength == 11 && telephoneNumber.startsWith("1");
    }
}

