/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import java.util.HashMap;
import java.util.Map;

public enum UnitedState {
    ALABAMA("ALABAMA", "AL"),
    ALASKA("ALASKA", "AK"),
    AMERICAN_SAMOA("AMERICAN SAMOA", "AS"),
    ARIZONA("ARIZONA", "AZ"),
    ARKANSAS("ARKANSAS", "AR"),
    CALIFORNIA("CALIFORNIA", "CA"),
    COLORADO("COLORADO", "CO"),
    CONNECTICUT("CONNECTICUT", "CT"),
    DELAWARE("DELAWARE", "DE"),
    DISTRICT_OF_COLUMBIA("DISTRICT OF COLUMBIA", "DC"),
    FEDERATED_STATES_OF_MICRONESIA("FEDERATED STATES OF MICRONESIA", "FM"),
    FLORIDA("FLORIDA", "FL"),
    GEORGIA("GEORGIA", "GA"),
    GUAM("GUAM", "GU"),
    HAWAII("HAWAII", "HI"),
    IDAHO("IDAHO", "ID"),
    ILLINOIS("ILLINOIS", "IL"),
    INDIANA("INDIANA", "IN"),
    IOWA("IOWA", "IA"),
    KANSAS("KANSAS", "KS"),
    KENTUCKY("KENTUCKY", "KY"),
    LOUISIANA("LOUISIANA", "LA"),
    MAINE("MAINE", "ME"),
    MARYLAND("MARYLAND", "MD"),
    MARSHALL_ISLANDS("MARSHALL ISLANDS", "MH"),
    MASSACHUSETTS("MASSACHUSETTS", "MA"),
    MICHIGAN("MICHIGAN", "MI"),
    MINNESOTA("MINNESOTA", "MN"),
    MISSISSIPPI("MISSISSIPPI", "MS"),
    MISSOURI("MISSOURI", "MO"),
    MONTANA("MONTANA", "MT"),
    NEBRASKA("NEBRASKA", "NE"),
    NEVADA("NEVADA", "NV"),
    NEW_HAMPSHIRE("NEW HAMPSHIRE", "NH"),
    NEW_JERSEY("NEW JERSEY", "NJ"),
    NEW_MEXICO("NEW MEXICO", "NM"),
    NEW_YORK("NEW YORK", "NY"),
    NORTH_CAROLINA("NORTH CAROLINA", "NC"),
    NORTH_DAKOTA("NORTH DAKOTA", "ND"),
    NORTHERN_MARIANA_ISLANDS("NORTHERN MARIANA ISLANDS", "MP"),
    OHIO("OHIO", "OH"),
    OKLAHOMA("OKLAHOMA", "OK"),
    OREGON("OREGON", "OR"),
    PALAU("PALAU", "PW"),
    PENNSYLVANIA("PENNSYLVANIA", "PA"),
    PUERTO_RICO("PUERTO RICO", "PR"),
    RHODE_ISLAND("RHODE ISLAND", "RI"),
    SOUTH_CAROLINA("SOUTH CAROLINA", "SC"),
    SOUTH_DAKOTA("SOUTH DAKOTA", "SD"),
    TENNESSEE("TENNESSEE", "TN"),
    TEXAS("TEXAS", "TX"),
    UTAH("UTAH", "UT"),
    VERMONT("VERMONT", "VT"),
    VIRGIN_ISLANDS("VIRGIN ISLANDS", "VI"),
    VIRGINIA("VIRGINIA", "VA"),
    WASHINGTON("WASHINGTON", "WA"),
    WEST_VIRGINIA("WEST VIRGINIA", "WV"),
    WISCONSIN("WISCONSIN", "WI"),
    WYOMING("WYOMING", "WY");

    private static final Map<String, String> UNITED_STATES;
    private String name;
    private String abbreviation;

    private UnitedState(String name, String abbreviation) {
        this.setName(name);
        this.setAbbreviation(abbreviation);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    private void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public static String getAbbreviation(String name) {
        String unitedStateName = name.toUpperCase().trim();
        if (UNITED_STATES.containsKey(unitedStateName)) {
            return UNITED_STATES.get(unitedStateName);
        }
        return name;
    }

    static {
        UNITED_STATES = new HashMap<String, String>();
        for (UnitedState state : UnitedState.values()) {
            UNITED_STATES.put(state.getName(), state.getAbbreviation());
        }
    }
}

