/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializer;
import java.io.IOException;

public class TitleCaseStringSerializer
extends StringSerializer {
    @Override
    public String serialize(String text) {
        String titleCasedText = text;
        if (text != null) {
            String fullName = text.trim().replaceAll(" +", " ").toLowerCase();
            char[] fullNameCharacters = fullName.toCharArray();
            for (int i = 0; i < fullNameCharacters.length; ++i) {
                char currentLetter = fullNameCharacters[i];
                if (i == 0) {
                    fullNameCharacters[i] = currentLetter = Character.toUpperCase(currentLetter);
                    continue;
                }
                char previousLetter = fullNameCharacters[i - 1];
                if (previousLetter != ' ' && previousLetter != '-' && previousLetter != '.') continue;
                fullNameCharacters[i] = currentLetter = Character.toUpperCase(currentLetter);
            }
            titleCasedText = new String(fullNameCharacters);
        }
        return titleCasedText;
    }

    public void serialize(String text, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeObject((Object)this.serialize(text));
    }
}

