/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class PostalCodeStringSerializer
extends StringSerializer {
    private static final int ZIP_CODE_LENGTH = 9;
    private static final int ZIP_CODE_DELIVERY_ROUTE_INDEX = 5;

    public void serialize(String text, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeObject((Object)this.serialize(text));
    }

    @Override
    public String serialize(String text) {
        Object zipCode = text.trim();
        if (StringUtils.isNotBlank((CharSequence)zipCode) && ((String)zipCode).length() == 9 && ((String)zipCode).matches("\\d{9}")) {
            String deliveryArea = ((String)zipCode).substring(0, 5);
            String deliveryRoute = ((String)zipCode).substring(5);
            zipCode = deliveryArea + "-" + deliveryRoute;
        }
        return zipCode;
    }
}

