/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.NumberFormat;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

abstract class NumberSerializer<T extends Number>
extends JsonSerializer<T> {
    protected final XLogger logger = XLoggerFactory.getXLogger(((Object)((Object)this)).getClass());
    protected NumberFormat numberFormat;

    NumberSerializer() {
        this.setNumberFormat();
    }

    public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(this.serialize(value));
    }

    protected String serialize(T value) {
        return this.numberFormat.format(value);
    }

    protected abstract void setNumberFormat();
}

