/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.number;

import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class IntegerUtils {
    private static final XLogger logger = XLoggerFactory.getXLogger(IntegerUtils.class);

    public static Integer tryParseInt(String text) {
        Integer value = null;
        if (text != null) {
            try {
                value = Integer.parseInt(text.trim());
            }
            catch (NumberFormatException e) {
                logger.warn("There was an error trying to parse " + text, (Throwable)e);
                value = null;
            }
        }
        return value;
    }

    public static Integer tryParseInt(String text, Integer defaultValue) {
        Integer value = IntegerUtils.tryParseInt(text);
        return value == null ? defaultValue : value;
    }

    public static Integer getValue(Integer number) {
        Integer value = 0;
        if (number != null) {
            value = number;
        }
        return value;
    }
}

