/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.date;

import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class DateUtils {
    protected static final XLogger logger = XLoggerFactory.getXLogger(DateUtils.class);

    public static XMLGregorianCalendar convertFromLocalDateToXmlGregorianCalendar(LocalDate date) {
        XMLGregorianCalendar xcal = null;
        if (date != null) {
            try {
                xcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(date.toString());
            }
            catch (DatatypeConfigurationException exception) {
                logger.warn("Error while converting from local date to xml gregorian calendar", (Throwable)exception);
                throw new ApplicationServerException((Throwable)exception);
            }
        }
        return xcal;
    }

    public static LocalDate convertFromXmlGregorianCalendarToLocalDate(XMLGregorianCalendar xcal) {
        LocalDate localDate = null;
        if (xcal != null) {
            localDate = xcal.toGregorianCalendar().toZonedDateTime().toLocalDate();
            logger.debug("Local date {}", (Object)localDate);
        }
        return localDate;
    }

    public static int compareTo(String datePattern, String dateText1, String dateText2) {
        LocalDate localDate2;
        int compareToValue = Integer.MAX_VALUE;
        LocalDate localDate1 = DateUtils.toLocalDate(datePattern, dateText1);
        if (localDate1 != null && (localDate2 = DateUtils.toLocalDate(datePattern, dateText2)) != null) {
            compareToValue = localDate1.compareTo(localDate2);
        }
        return compareToValue;
    }

    public static LocalDate toLocalDate(String datePattern, String dateText) {
        LocalDate localDate = null;
        if (StringUtils.isNotBlank((CharSequence)datePattern) && StringUtils.isNotBlank((CharSequence)dateText)) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(datePattern);
            try {
                localDate = LocalDate.parse(dateText, dateTimeFormatter);
            }
            catch (DateTimeParseException e) {
                logger.warn("Date time could not be parsed", (Throwable)e);
            }
        }
        return localDate;
    }

    public static Date convertFromLocalDateToDate(LocalDateTime dateToConvert) {
        return Date.from(dateToConvert.atZone(ZoneId.systemDefault()).toInstant());
    }
}

