/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import io.americanexpress.synapse.utilities.common.serialization.NumberSerializer;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class CurrencySerializer
extends NumberSerializer<BigDecimal> {
    @Override
    protected void setNumberFormat() {
        this.numberFormat = NumberFormat.getCurrencyInstance(Locale.getDefault());
    }

    @Override
    protected String serialize(BigDecimal value) {
        Object formattedValue;
        if (value.doubleValue() < 0.0) {
            value = value.multiply(BigDecimal.valueOf(-1L));
            formattedValue = this.numberFormat.format(value);
            formattedValue = "-" + (String)formattedValue;
        } else {
            formattedValue = this.numberFormat.format(value);
        }
        return formattedValue;
    }

    @Override
    public String serialize(String text) {
        String serializedValue = text;
        if (StringUtils.isNotBlank((CharSequence)text)) {
            text = text.trim();
            try {
                BigDecimal bigDecimal = new BigDecimal(text);
                serializedValue = this.serialize(bigDecimal);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("An exception occurred while trying to create the BigDecimal from " + text, (Throwable)numberFormatException);
            }
        }
        return serializedValue;
    }
}

