/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.miscellaneous;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

public class StringCommonUtils {
    private StringCommonUtils() {
    }

    public static String convertSpaceAndDashToUnderscore(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = value.trim().replaceAll("\\s+|-+", "_");
        }
        return value;
    }

    public static String removeSpecialCharacters(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = value.trim().replaceAll("\\\\+|\\\"|\\:|\\@|\\/|\\.|\\#|\\(|\\)|\\%|\\$|\\^|\\+|\\=|\\!|\\'|\\<|\\>|\\?|\\/|\\;", "");
        }
        return value;
    }

    public static String enumerate(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = StringCommonUtils.removeSpecialCharacters(value);
            value = StringCommonUtils.convertSpaceAndDashToUnderscore(value);
            value = value.toUpperCase();
        }
        return value;
    }

    public static String convertSnakeCaseToPascalCase(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = CaseUtils.toCamelCase((String)value, (boolean)true, (char[])new char[]{'_'});
        }
        return value;
    }

    public static boolean checkForNullString(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && !"null".equals(value);
    }
}

