/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.date;

import java.time.ZoneId;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TimeUtils {
    public static final ZoneId AMERICA_PHOENIX_ZONE_ID = ZoneId.of("America/Phoenix");
    public static final Pattern ISO8601_TIME_PATTERN = Pattern.compile("^(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?$");

    private TimeUtils() {
    }

    public static boolean isIso8601Time(String time) {
        return StringUtils.isNotBlank((CharSequence)time) && ISO8601_TIME_PATTERN.matcher(time).matches();
    }

    public static boolean isHhmmssTime(String time) {
        String formattedTime = time;
        boolean isValid = false;
        if (StringUtils.isNumeric((CharSequence)time) && formattedTime.length() == 6) {
            formattedTime = new StringJoiner(":").add(formattedTime.substring(0, 2)).add(formattedTime.substring(2, 4)).add(formattedTime.substring(4, 6)).toString();
            isValid = TimeUtils.isIso8601Time(formattedTime);
        }
        return isValid;
    }
}

