/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.date;

import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import io.americanexpress.synapse.utilities.common.date.TimeZone;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class DateUtils {
    protected static final XLogger logger = XLoggerFactory.getXLogger(DateUtils.class);
    public static final Pattern ISO8601_DATE_PATTERN = Pattern.compile("^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)$");

    private DateUtils() {
    }

    public static XMLGregorianCalendar convertFromLocalDateToXmlGregorianCalendar(LocalDate date) {
        XMLGregorianCalendar xcal = null;
        if (date != null) {
            try {
                xcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(date.toString());
            }
            catch (DatatypeConfigurationException exception) {
                logger.warn("Error while converting from local date to xml gregorian calendar", (Throwable)exception);
                throw new ApplicationServerException((Throwable)exception);
            }
        }
        return xcal;
    }

    public static LocalDate convertFromXmlGregorianCalendarToLocalDate(XMLGregorianCalendar xcal) {
        LocalDate localDate = null;
        if (xcal != null) {
            localDate = xcal.toGregorianCalendar().toZonedDateTime().toLocalDate();
            logger.debug("Local date {}", (Object)localDate);
        }
        return localDate;
    }

    public static int compareTo(String datePattern, String dateText1, String dateText2) {
        LocalDate localDate2;
        int compareToValue = Integer.MAX_VALUE;
        LocalDate localDate1 = DateUtils.toLocalDate(datePattern, dateText1);
        if (localDate1 != null && (localDate2 = DateUtils.toLocalDate(datePattern, dateText2)) != null) {
            compareToValue = localDate1.compareTo(localDate2);
        }
        return compareToValue;
    }

    public static LocalDate toLocalDate(String datePattern, String dateText) {
        LocalDate localDate = null;
        if (StringUtils.isNotBlank((CharSequence)datePattern) && StringUtils.isNotBlank((CharSequence)dateText)) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(datePattern);
            try {
                localDate = LocalDate.parse(dateText, dateTimeFormatter);
            }
            catch (DateTimeParseException e) {
                logger.warn("Date time could not be parsed", (Throwable)e);
            }
        }
        return localDate;
    }

    public static Date convertFromLocalDateToDate(LocalDateTime dateToConvert) {
        return Date.from(dateToConvert.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean isIso8601Date(String date) {
        return StringUtils.isNotBlank((CharSequence)date) && ISO8601_DATE_PATTERN.matcher(date).matches();
    }

    public static boolean isYyyyMmDdDate(String date) {
        String formattedDate = date;
        boolean isValid = false;
        if (StringUtils.isNumeric((CharSequence)date) && formattedDate.length() == 8) {
            formattedDate = new StringJoiner("-").add(date.substring(0, 4)).add(date.substring(4, 6)).add(date.substring(6, 8)).toString();
            isValid = DateUtils.isIso8601Date(formattedDate);
        }
        return isValid;
    }

    static LocalDateTime toLocalDateTime(String dateTimePattern, String dateTimeText) {
        LocalDateTime localDateTime = DateUtils.parseLocalDateTime(dateTimeText, dateTimePattern);
        return localDateTime;
    }

    private static LocalDateTime parseLocalDateTime(String stringLocalDateTime, String localDateTimePattern) {
        LocalDateTime localDateTime = null;
        if (StringUtils.isNotBlank((CharSequence)localDateTimePattern) && StringUtils.isNotBlank((CharSequence)stringLocalDateTime)) {
            try {
                localDateTime = LocalDateTime.parse(stringLocalDateTime, DateTimeFormatter.ofPattern(localDateTimePattern));
            }
            catch (DateTimeParseException dateTimeParseException) {
                logger.debug("Date time could not be parsed from backend API for String date: {} and pattern: {}", (Object)stringLocalDateTime, (Object)localDateTimePattern);
            }
        }
        return localDateTime;
    }

    public static long convertFromLocalDateTimeToLongEpoch(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.of(TimeZone.MST.getValue())).toEpochSecond();
    }

    public static long convertFromLocalDateTimeToLongEpochMilliSeconds(LocalDateTime localDateTime) {
        return ZonedDateTime.of(localDateTime, ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

