/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.americanexpress.synapse.framework.exception.config.ExceptionConfig;
import io.americanexpress.synapse.utilities.common.serialization.CurrencySerializer;
import io.americanexpress.synapse.utilities.common.serialization.DateIsoDeserializer;
import io.americanexpress.synapse.utilities.common.serialization.DateIsoSerializer;
import io.americanexpress.synapse.utilities.common.serialization.DateTimeDeserializer;
import io.americanexpress.synapse.utilities.common.serialization.DateTimeSerializer;
import io.americanexpress.synapse.utilities.common.serialization.DecimalSerializer;
import io.americanexpress.synapse.utilities.common.serialization.MoneyDeserializer;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializerModule;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@ComponentScan(basePackages={"io.americanexpress.synapse.utilities.common"})
@Import(value={ExceptionConfig.class})
public class UtilitiesCommonConfig {
    public static final String SYNAPSE_OBJECT_MAPPER = "synapseObjectMapper";
    public static final String SYNAPSE_CAMEL_CASE_OBJECT_MAPPER = "synapseCamelCaseObjectMapper";
    public static final String SYNAPSE_INCLUDE_EMPTY_OBJECT_MAPPER = "synapseIncludeEmptyObjectMapper";
    public static final String SYNAPSE_XML_OBJECT_MAPPER = "synapseXmlObjectMapper";

    private ObjectMapper getInitialObjectMapper() {
        JavaTimeModule javaTimeDeserializerModule = new JavaTimeModule();
        javaTimeDeserializerModule.addDeserializer(LocalDate.class, (JsonDeserializer)new DateIsoDeserializer());
        javaTimeDeserializerModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        JavaTimeModule javaTimeSerializerModule = new JavaTimeModule();
        javaTimeDeserializerModule.addSerializer(LocalDate.class, (JsonSerializer)new DateIsoSerializer());
        javaTimeDeserializerModule.addSerializer(LocalDateTime.class, (JsonSerializer)new DateTimeSerializer());
        SimpleModule moneySerializer = new SimpleModule();
        moneySerializer.addSerializer(BigDecimal.class, (JsonSerializer)new CurrencySerializer());
        SimpleModule moneyDeserializer = new SimpleModule();
        moneyDeserializer.addDeserializer(BigDecimal.class, (JsonDeserializer)new MoneyDeserializer());
        SimpleModule decimalSerializer = new SimpleModule();
        decimalSerializer.addSerializer(Double.class, (JsonSerializer)new DecimalSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new StringSerializerModule());
        mapper.registerModule((Module)moneySerializer);
        mapper.registerModule((Module)moneyDeserializer);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.registerModule((Module)javaTimeDeserializerModule);
        mapper.registerModule((Module)javaTimeSerializerModule);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)decimalSerializer);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        return mapper;
    }

    @Bean(value={"synapseObjectMapper"})
    public ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = this.getInitialObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    @Bean(value={"synapseCamelCaseObjectMapper"})
    @Primary
    public ObjectMapper camelCaseObjectMapper() {
        ObjectMapper mapper = this.getInitialObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        return mapper;
    }

    @Bean(value={"synapseXmlObjectMapper"})
    public ObjectMapper xmlObjectMapper() {
        XmlMapper objectMapper = new XmlMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    @Bean(value={"synapseIncludeEmptyObjectMapper"})
    public ObjectMapper includeEmptyObjectMapper() {
        return this.getInitialObjectMapper();
    }
}

