/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class StringSerializerModule
extends SimpleModule {
    private static final long serialVersionUID = 6915711829365191165L;

    public StringSerializerModule() {
        this.addSerializer(String.class, (JsonSerializer)new StdScalarSerializer<String>(String.class){
            private static final long serialVersionUID = -811924893592732901L;

            public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value);
            }

            public boolean isEmpty(SerializerProvider provider, String value) {
                return StringUtils.isBlank((CharSequence)value);
            }
        });
    }
}

