/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializer;
import java.io.IOException;

public class NationalIdentifierStringSerializer
extends StringSerializer {
    private static final int IDENTIFIERS_LENGTH = 9;
    private static final int AREA_NUMBER_INDEX = 0;
    private static final int GROUP_NUMBER_INDEX = 3;
    private static final int SERIAL_NUMBER_INDEX = 5;

    @Override
    public String serialize(String text) {
        Object identifiers = text.trim();
        if (((String)identifiers).length() == 9 && ((String)identifiers).matches("\\d{9}")) {
            String areaNumber = ((String)identifiers).substring(0, 3);
            String groupNumber = ((String)identifiers).substring(3, 5);
            String serialNumber = ((String)identifiers).substring(5);
            identifiers = areaNumber + "-" + groupNumber + "-" + serialNumber;
        }
        return identifiers;
    }

    public void serialize(String text, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeObject((Object)this.serialize(text));
    }
}

