/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.serialization.NumberSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

abstract class DoubleSerializer
extends NumberSerializer<Double> {
    DoubleSerializer() {
    }

    @Override
    public void serialize(Double value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(this.serialize(value));
    }

    @Override
    public String serialize(String text) {
        String serializedValue = text;
        if (StringUtils.isNotBlank((CharSequence)text)) {
            text = text.trim();
            try {
                Double value = Double.valueOf(text);
                serializedValue = this.serialize(value);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("An exception occurred while trying to create the Double from " + text, (Throwable)numberFormatException);
            }
        }
        return serializedValue;
    }
}

