/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.americanexpress.synapse.utilities.common.serialization.StringSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class AllCharactersMaskStringSerializer
extends StringSerializer {
    private static final String MASKED_CHARACTER = "*";
    private static final String MASKING_REGEX = ".(?=.{%s})";

    public void serialize(String text, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeObject((Object)this.serialize(text));
    }

    @Override
    public String serialize(String text) {
        return AllCharactersMaskStringSerializer.serialize(text, 0);
    }

    public static String serialize(String text, int unmaskedCharactersCount) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        return text.replaceAll(String.format(MASKING_REGEX, String.valueOf(unmaskedCharactersCount)), MASKED_CHARACTER);
    }
}

