/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.io;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ClasspathObjectFactory {
    private ObjectMapper mapper;

    public ClasspathObjectFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public <T> T create(String filePath, Class<T> classType) throws IOException {
        ClassPathResource resource = new ClassPathResource(filePath);
        InputStream inputStream = resource.getInputStream();
        return (T)this.mapper.readValue(inputStream, classType);
    }

    public String create(String filePath) throws IOException, URISyntaxException {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(filePath).toURI());
        Stream<String> stream = Files.lines(path);
        String text = stream.collect(Collectors.joining());
        stream.close();
        return text;
    }

    public Object createFromXml(String filePath, Class<?> classType) throws IOException {
        ClassPathResource resource = new ClassPathResource(filePath);
        InputStream inputStream = resource.getInputStream();
        XmlMapper objectMapper = new XmlMapper();
        objectMapper.registerModule((Module)new JaxbAnnotationModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper.readValue(inputStream, classType);
    }
}

