/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.utilities.common.cryptography;

import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.salt.SaltGenerator;
import org.jasypt.salt.ZeroSaltGenerator;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class CryptoUtil {
    private static final String ENCRYPTION_KEY = System.getenv("ENCRYPTION_KEY");
    private static final String ALGORITHM_KEY = System.getenv("ALGORITHM_KEY");
    private static final XLogger logger = XLoggerFactory.getXLogger(CryptoUtil.class);
    private static final StandardPBEStringEncryptor textEncryptor;

    private CryptoUtil() {
    }

    public static String jasyptEncrypt(String text) {
        logger.entry(new Object[]{text});
        String encrypted = null;
        if (textEncryptor != null && text != null) {
            encrypted = textEncryptor.encrypt(text).replace("/", "_").replace("\\+", "-");
        }
        return encrypted;
    }

    public static String jasyptDecrypt(String text) {
        logger.entry(new Object[]{text});
        String decrypted = text;
        if (!StringUtils.isNumeric((CharSequence)text) && textEncryptor != null && text != null) {
            String encrypted = text.replace("_", "/").replace("-", "\\+");
            decrypted = textEncryptor.decrypt(encrypted);
        }
        return decrypted;
    }

    public static String tryJasyptEncrypt(String text) {
        String encrypted;
        try {
            encrypted = CryptoUtil.jasyptEncrypt(text);
        }
        catch (EncryptionOperationNotPossibleException exception) {
            logger.catching((Throwable)exception);
            encrypted = text;
        }
        return encrypted;
    }

    public static String tryJasyptDecrypt(String text) {
        String decrypted;
        try {
            decrypted = CryptoUtil.jasyptDecrypt(text);
        }
        catch (EncryptionOperationNotPossibleException exception) {
            logger.warn("There was an error trying to decrypt " + text, (Throwable)exception);
            decrypted = text;
        }
        return decrypted;
    }

    static {
        logger.entry(new Object[0]);
        textEncryptor = new StandardPBEStringEncryptor();
        textEncryptor.setAlgorithm(ALGORITHM_KEY);
        textEncryptor.setPassword(ENCRYPTION_KEY);
        ZeroSaltGenerator saltGenerator = new ZeroSaltGenerator();
        textEncryptor.setSaltGenerator((SaltGenerator)saltGenerator);
        textEncryptor.initialize();
        logger.exit((Object)textEncryptor);
    }
}

