/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.subscriber.kafka.service;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.Lifecycle;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.stereotype.Service;

@Service
public class BaseKafkaSubscriberSupportService {
    private final KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry;

    public BaseKafkaSubscriberSupportService(KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry) {
        this.kafkaListenerEndpointRegistry = kafkaListenerEndpointRegistry;
    }

    public void startSubscribers() {
        this.kafkaListenerEndpointRegistry.getListenerContainers().forEach(Lifecycle::start);
    }

    public Map<String, String> getSubscribersStatus() {
        HashMap<String, String> listenerStatus = new HashMap<String, String>();
        this.kafkaListenerEndpointRegistry.getAllListenerContainers().forEach(listenerContainer -> listenerStatus.put(listenerContainer.getListenerId(), String.valueOf(listenerContainer.isRunning())));
        return listenerStatus;
    }

    public void stopSubscribers() {
        this.kafkaListenerEndpointRegistry.getListenerContainers().forEach(Lifecycle::stop);
    }
}

