/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.subscriber.kafka.errorhandler;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.event.ConsumerFailedToStartEvent;
import org.springframework.kafka.event.ConsumerStartedEvent;
import org.springframework.kafka.event.ConsumerStoppedEvent;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class ConsumerEventLogger {
    protected final XLogger log = XLoggerFactory.getXLogger(this.getClass());

    @EventListener(value={ConsumerStoppedEvent.class})
    public void consumerStoppedEventHandler(ConsumerStoppedEvent event) {
        Set topics = Arrays.stream(((KafkaMessageListenerContainer)event.getSource()).getContainerProperties().getTopics()).collect(Collectors.toSet());
        this.log.info("LISTENER_STATUS: {}, TOPIC(S): {}, REASON: {}", new Object[]{"STOPPED", topics, event.getReason()});
    }

    @EventListener(value={ConsumerStartedEvent.class})
    public void consumerStartedEventHandler(ConsumerStartedEvent event) {
        Set topics = Arrays.stream(((KafkaMessageListenerContainer)event.getSource()).getContainerProperties().getTopics()).collect(Collectors.toSet());
        this.log.info("LISTENER_STATUS: {}, TOPIC(S): {}", (Object)"STARTED", topics);
    }

    @EventListener(value={ConsumerFailedToStartEvent.class})
    public void consumerFailedToStartEventHandler(ConsumerFailedToStartEvent event) {
        Set topics = Arrays.stream(((KafkaMessageListenerContainer)event.getSource()).getContainerProperties().getTopics()).collect(Collectors.toSet());
        this.log.info("LISTENER_STATUS: {}, TOPIC(S): {}", (Object)"FAILED_TO_STARTED", topics);
    }
}

