/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.subscriber.kafka.config;

import io.americanexpress.synapse.subscriber.kafka.config.BaseKafkaPropertiesConfiguration;
import io.americanexpress.synapse.subscriber.kafka.errorhandler.BaseKafkaSubscriberErrorHandler;
import io.americanexpress.synapse.subscriber.kafka.filter.BaseKafkaSubscriberMessageFilter;
import io.americanexpress.synapse.subscriber.kafka.interceptor.BaseKafkaSubscriberMetricInterceptor;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;

@EnableKafka
public abstract class BaseKafkaSubscriberConfiguration<C extends BaseKafkaPropertiesConfiguration, E extends BaseKafkaSubscriberErrorHandler, F extends BaseKafkaSubscriberMessageFilter, I extends BaseKafkaSubscriberMetricInterceptor> {
    private static final String partitionCountKey = "kafka.partitions.count";
    private static final String recordFilterEnabledKey = "kafka.subscriber.filter.enabled";
    private static final String batchSubscriberEnabledKey = "kafka.subscriber.batch.enabled";
    private final C kafkaPropertiesConfiguration;
    private final I recordInterceptor;
    private final E kafkaErrorHandler;
    private F recordFilteringStrategy;
    private final Integer partitions;
    private final boolean recordFilteringEnabled;
    private final boolean batchSubscriberEnabled;

    public boolean isRecordFilteringEnabled() {
        return this.recordFilteringEnabled;
    }

    public boolean isBatchSubscriberEnabled() {
        return this.batchSubscriberEnabled;
    }

    protected BaseKafkaSubscriberConfiguration(C kafkaPropertiesConfiguration, E kafkaErrorHandler, F recordFilteringStrategy, Environment environment, I recordInterceptor) {
        this(kafkaPropertiesConfiguration, kafkaErrorHandler, environment, recordInterceptor);
        this.recordFilteringStrategy = recordFilteringStrategy;
    }

    protected BaseKafkaSubscriberConfiguration(C kafkaPropertiesConfiguration, E kafkaErrorHandler, Environment environment, I recordInterceptor) {
        this.kafkaPropertiesConfiguration = kafkaPropertiesConfiguration;
        this.kafkaErrorHandler = kafkaErrorHandler;
        this.recordInterceptor = recordInterceptor;
        this.partitions = Optional.ofNullable((Integer)environment.getProperty(partitionCountKey, Integer.class)).orElse(1);
        this.batchSubscriberEnabled = Optional.ofNullable((Boolean)environment.getProperty(batchSubscriberEnabledKey, Boolean.class)).orElse(Boolean.FALSE);
        this.recordFilteringEnabled = Optional.ofNullable((Boolean)environment.getProperty(recordFilterEnabledKey, Boolean.class)).orElse(Boolean.FALSE);
        this.recordFilteringStrategy = null;
    }

    private ConsumerFactory<String, Object> consumerFactory() {
        return new DefaultKafkaConsumerFactory(((BaseKafkaPropertiesConfiguration)((Object)this.kafkaPropertiesConfiguration)).buildConsumerProperties());
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<String, Object> baseKafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConcurrency(this.partitions);
        factory.setConsumerFactory(this.consumerFactory());
        if (this.isRecordFilteringEnabled()) {
            factory.setAckDiscarded(Boolean.valueOf(true));
            factory.setRecordFilterStrategy((RecordFilterStrategy)Optional.ofNullable(this.recordFilteringStrategy).orElseThrow(() -> new IllegalArgumentException("Please consider defining a bean of type: " + BaseKafkaSubscriberMessageFilter.class)));
        }
        if (!Optional.ofNullable(((BaseKafkaPropertiesConfiguration)((Object)this.kafkaPropertiesConfiguration)).getConsumer().getEnableAutoCommit()).orElse(Boolean.FALSE).booleanValue()) {
            factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.MANUAL_IMMEDIATE);
        }
        if (this.isBatchSubscriberEnabled()) {
            factory.setBatchListener(Boolean.valueOf(this.batchSubscriberEnabled));
            factory.setBatchInterceptor(this.recordInterceptor);
        }
        factory.setCommonErrorHandler((CommonErrorHandler)Optional.ofNullable(this.kafkaErrorHandler).orElseThrow(() -> new IllegalArgumentException("Please consider defining a bean of type: " + BaseKafkaSubscriberErrorHandler.class)));
        factory.setRecordInterceptor(this.recordInterceptor);
        return factory;
    }
}

