/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.subscriber.kafka.config;

import io.americanexpress.synapse.framework.exception.ApplicationServerException;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public abstract class BaseKafkaPropertiesConfiguration<C extends BaseKafkaConsumer, S extends BaseKafkaSsl>
extends KafkaProperties {
    private final C consumer;
    private final S ssl;
    private final Environment environment;

    protected BaseKafkaPropertiesConfiguration(C consumer, S ssl, Environment environment) {
        this.consumer = consumer;
        this.ssl = ssl;
        this.environment = environment;
    }

    public List<String> getBootstrapServers() {
        return Collections.singletonList(this.environment.getRequiredProperty("kafka.bootstrap.servers"));
    }

    public KafkaProperties.Ssl getSsl() {
        return this.ssl;
    }

    public KafkaProperties.Consumer getConsumer() {
        return this.consumer;
    }

    public Map<String, Object> buildConsumerProperties() {
        return this.getConsumer().buildProperties();
    }

    public static abstract class BaseKafkaConsumer
    extends KafkaProperties.Consumer {
        private final Environment environment;

        protected BaseKafkaConsumer(Environment environment) {
            this.environment = environment;
        }

        public List<String> getBootstrapServers() {
            return Collections.singletonList(this.environment.getRequiredProperty("kafka.bootstrap.servers"));
        }

        public Boolean getEnableAutoCommit() {
            return false;
        }

        public Class<?> getKeyDeserializer() {
            return StringDeserializer.class;
        }

        public Class<?> getValueDeserializer() {
            return StringDeserializer.class;
        }

        public Integer getMaxPollRecords() {
            return Optional.ofNullable((Integer)this.environment.getProperty("kafka.subscriber.maximum.poll.records", Integer.class)).orElse(1);
        }
    }

    public static abstract class BaseKafkaSsl
    extends KafkaProperties.Ssl {
        private final Environment environment;
        private final ResourceLoader resourceLoader;

        protected BaseKafkaSsl(Environment environment, ResourceLoader resourceLoader) {
            this.environment = environment;
            this.resourceLoader = resourceLoader;
        }

        public String getKeyPassword() {
            return this.environment.getRequiredProperty("kafka.key.password");
        }

        public String getKeyStorePassword() {
            return this.environment.getRequiredProperty("kafka.keyStore.password");
        }

        public String getKeyStoreType() {
            return this.environment.getRequiredProperty("kafka.keyStore.type");
        }

        public Resource getKeyStoreLocation() {
            Resource resource = this.resourceLoader.getResource(this.environment.getRequiredProperty("kafka.keyStore.location"));
            if (!resource.exists()) {
                throw new ApplicationServerException((Throwable)new FileNotFoundException(resource.getDescription() + " not found"));
            }
            return resource;
        }

        public Resource getTrustStoreLocation() {
            Resource resource = this.resourceLoader.getResource(this.environment.getRequiredProperty("kafka.trustStore.location"));
            if (!resource.exists()) {
                throw new ApplicationServerException((Throwable)new FileNotFoundException(resource.getDescription() + " not found"));
            }
            return resource;
        }

        public String getTrustStorePassword() {
            return this.environment.getRequiredProperty("kafka.trustStore.password");
        }

        public String getTrustStoreType() {
            return this.environment.getRequiredProperty("kafka.trustStore.type");
        }

        public String getProtocol() {
            return this.environment.getRequiredProperty("protocol");
        }
    }
}

