/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.service.test.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.americanexpress.synapse.service.rest.model.BaseServiceResponse;
import io.americanexpress.synapse.utilities.common.io.IOUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@ExtendWith(value={SpringExtension.class})
public abstract class BaseControllerTest<O extends BaseServiceResponse> {
    protected O response;
    @Autowired
    protected ObjectMapper objectMapper;
    protected MockMvc mockMvc;
    protected String jsonRequest;
    @Autowired
    protected WebApplicationContext webApplicationContext;

    protected abstract String getEndpoint();

    protected abstract String getSampleJsonRequestFileName();

    protected abstract HttpHeaders getSampleHttpHeaders();

    protected ResultActions testEndpoint(String endPoint) throws Exception {
        return this.sendRequestAndAssert(endPoint, HttpMethod.POST, HttpStatus.OK, null);
    }

    protected ResultActions testEndpoint(String endPoint, String responseExpected) throws Exception {
        return this.sendRequestAndAssert(endPoint, HttpMethod.POST, HttpStatus.OK, responseExpected);
    }

    protected ResultActions testEndpoint(String endPoint, HttpMethod httpMethod) throws Exception {
        return this.sendRequestAndAssert(endPoint, httpMethod, HttpStatus.OK, null);
    }

    protected ResultActions testEndpoint(String endPoint, HttpMethod httpMethod, String responseExpected) throws Exception {
        return this.sendRequestAndAssert(endPoint, httpMethod, HttpStatus.OK, responseExpected);
    }

    protected ResultActions testEndpoint(String endPoint, HttpStatus httpStatusExpected) throws Exception {
        return this.sendRequestAndAssert(endPoint, HttpMethod.POST, httpStatusExpected, null);
    }

    protected ResultActions testEndpoint(String endPoint, HttpMethod httpMethod, HttpStatus httpStatusExpected) throws Exception {
        return this.sendRequestAndAssert(endPoint, httpMethod, httpStatusExpected, null);
    }

    protected ResultActions testEndpoint(String endPoint, HttpStatus httpStatusExpected, String responseExpected) throws Exception {
        return this.sendRequestAndAssert(endPoint, HttpMethod.POST, httpStatusExpected, responseExpected);
    }

    protected ResultActions testEndpoint(String endPoint, HttpMethod httpMethod, HttpStatus httpStatusExpected, String responseExpected) throws Exception {
        return this.sendRequestAndAssert(endPoint, httpMethod, httpStatusExpected, responseExpected);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).alwaysDo(MockMvcResultHandlers.print())).build();
    }

    private ResultActions sendRequestAndAssert(String endPoint, HttpMethod httpMethod, HttpStatus httpStatusExpected, String responseExpected) throws Exception {
        String fileNameWithSampleJsonRequest = this.getSampleJsonRequestFileName();
        if (StringUtils.isNotBlank((CharSequence)fileNameWithSampleJsonRequest)) {
            this.jsonRequest = IOUtils.readFileToAString((String)fileNameWithSampleJsonRequest);
        }
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = null;
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            mockHttpServletRequestBuilder = MockMvcRequestBuilders.post((String)endPoint, (Object[])new Object[0]);
        } else if (HttpMethod.PUT.equals((Object)httpMethod)) {
            mockHttpServletRequestBuilder = MockMvcRequestBuilders.put((String)endPoint, (Object[])new Object[0]);
        } else if (HttpMethod.PATCH.equals((Object)httpMethod)) {
            mockHttpServletRequestBuilder = MockMvcRequestBuilders.patch((String)endPoint, (Object[])new Object[0]);
        } else if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            mockHttpServletRequestBuilder = MockMvcRequestBuilders.delete((String)endPoint, (Object[])new Object[0]);
        } else if (HttpMethod.GET.equals((Object)httpMethod)) {
            mockHttpServletRequestBuilder = MockMvcRequestBuilders.get((String)endPoint, (Object[])new Object[0]);
        }
        assert (mockHttpServletRequestBuilder != null);
        if (this.getSampleHttpHeaders() == null || this.getSampleHttpHeaders().isEmpty()) {
            mockHttpServletRequestBuilder.contentType("application/json");
        } else {
            mockHttpServletRequestBuilder.headers(this.getSampleHttpHeaders());
        }
        if (StringUtils.isNotBlank((CharSequence)this.jsonRequest)) {
            mockHttpServletRequestBuilder.content(this.jsonRequest);
        }
        ResultActions resultActions = this.mockMvc.perform((RequestBuilder)mockHttpServletRequestBuilder).andDo(MockMvcResultHandlers.print());
        if (httpStatusExpected != null) {
            if (HttpStatus.OK.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().isOk());
            } else if (HttpStatus.CREATED.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().isCreated());
            } else if (HttpStatus.BAD_REQUEST.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().is4xxClientError());
            } else if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().is5xxServerError());
            } else if (HttpStatus.FORBIDDEN.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().isForbidden());
            } else if (HttpStatus.UNAUTHORIZED.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().isUnauthorized());
            } else if (HttpStatus.NO_CONTENT.equals((Object)httpStatusExpected)) {
                resultActions.andExpect(MockMvcResultMatchers.status().isNoContent());
            } else {
                Assertions.fail();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)responseExpected)) {
            resultActions.andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)responseExpected)));
        }
        return resultActions;
    }

    protected Class<O> getResponseType() {
        Type type = this.getClass().getGenericSuperclass();
        Class responseType = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        return responseType;
    }
}

